/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import java.util.Map;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.model.internal.type.ModelType;

public abstract class PrimitiveTypes {
    private static final Map<ModelType<?>, Object> TYPES_DEFAULT_VALUES = ImmutableMap.builder().put(ModelType.of(Boolean.TYPE), false).put(ModelType.of(Character.TYPE), (Boolean)((Object)Character.valueOf('\u0000'))).put(ModelType.of(Byte.TYPE), (Boolean)((Object)Byte.valueOf((byte)0))).put(ModelType.of(Short.TYPE), (Boolean)((Object)Short.valueOf((short)0))).put(ModelType.of(Integer.TYPE), (Boolean)((Object)Integer.valueOf(0))).put(ModelType.of(Float.TYPE), (Boolean)((Object)Float.valueOf(0.0f))).put(ModelType.of(Long.TYPE), (Boolean)((Object)Long.valueOf(0L))).put(ModelType.of(Double.TYPE), (Boolean)((Object)Double.valueOf(0.0))).build();

    public static boolean isPrimitiveType(ModelType<?> modelType) {
        return TYPES_DEFAULT_VALUES.containsKey(modelType);
    }

    public static Object defaultValueOf(ModelType<?> primitiveModelType) {
        Object defaultValue = TYPES_DEFAULT_VALUES.get(primitiveModelType);
        if (defaultValue == null) {
            throw new IllegalArgumentException(primitiveModelType + " is not a primitive type.");
        }
        return defaultValue;
    }
}

