/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelTypes;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.NativeDependencySet;
import org.gradle.nativeplatform.NativeExecutableFileSpec;
import org.gradle.nativeplatform.NativeInstallationSpec;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.VariantComponentSpec;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolvedResult;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolver;

public class NativeComponents {
    private static final String ASSEMBLE_DEPENDENTS_TASK_NAME = "assembleDependents";
    private static final String BUILD_DEPENDENTS_TASK_NAME = "buildDependents";

    public static void createExecutableTask(final NativeBinarySpecInternal binary, final File executableFile) {
        String taskName = binary.getNamingScheme().getTaskName("link");
        binary.getTasks().create(taskName, LinkExecutable.class, new Action<LinkExecutable>(){

            @Override
            public void execute(LinkExecutable linkTask) {
                linkTask.setDescription("Links " + binary.getDisplayName());
                linkTask.getToolChain().set(binary.getToolChain());
                linkTask.getTargetPlatform().set(binary.getTargetPlatform());
                linkTask.getLinkedFile().set(executableFile);
                linkTask.getLinkerArgs().set(binary.getLinker().getArgs());
                linkTask.lib(new BinaryLibs(binary){

                    @Override
                    protected FileCollection getFiles(NativeDependencySet nativeDependencySet) {
                        return nativeDependencySet.getLinkFiles();
                    }
                });
                binary.builtBy(linkTask);
            }
        });
    }

    public static void createInstallTask(final NativeBinarySpecInternal binary, final NativeInstallationSpec installation, final NativeExecutableFileSpec executable, BinaryNamingScheme namingScheme) {
        binary.getTasks().create(namingScheme.getTaskName("install"), InstallExecutable.class, new Action<InstallExecutable>(){

            @Override
            public void execute(InstallExecutable installTask) {
                installTask.setDescription("Installs a development image of " + binary.getDisplayName());
                installTask.setGroup("build");
                installTask.getToolChain().set(executable.getToolChain());
                installTask.getTargetPlatform().set(binary.getTargetPlatform());
                installTask.getExecutableFile().set(executable.getFile());
                installTask.getInstallDirectory().set(installation.getDirectory());
                installTask.lib(new BinaryLibs(binary){

                    @Override
                    protected FileCollection getFiles(NativeDependencySet nativeDependencySet) {
                        return nativeDependencySet.getRuntimeFiles();
                    }
                });
                installTask.dependsOn(binary);
            }
        });
    }

    public static void createBuildDependentComponentsTasks(ModelMap<Task> tasks, ComponentSpecContainer components) {
        for (final VariantComponentSpec component : components.withType(NativeComponentSpec.class).withType(VariantComponentSpec.class)) {
            tasks.create(NativeComponents.getAssembleDependentComponentsTaskName(component), DefaultTask.class, new Action<DefaultTask>(){

                @Override
                public void execute(DefaultTask assembleDependents) {
                    assembleDependents.setGroup("Build Dependents");
                    assembleDependents.setDescription("Assemble dependents of " + component.getDisplayName() + ".");
                }
            });
            tasks.create(NativeComponents.getBuildDependentComponentsTaskName(component), DefaultTask.class, new Action<DefaultTask>(){

                @Override
                public void execute(DefaultTask buildDependents) {
                    buildDependents.setGroup("Build Dependents");
                    buildDependents.setDescription("Build dependents of " + component.getDisplayName() + ".");
                }
            });
        }
    }

    public static void createBuildDependentBinariesTasks(final NativeBinarySpecInternal binary, BinaryNamingScheme namingScheme) {
        binary.getTasks().create(namingScheme.getTaskName(ASSEMBLE_DEPENDENTS_TASK_NAME), DefaultTask.class, new Action<DefaultTask>(){

            @Override
            public void execute(DefaultTask buildDependentsTask) {
                buildDependentsTask.setGroup("Build Dependents");
                buildDependentsTask.setDescription("Assemble dependents of " + binary.getDisplayName() + ".");
                buildDependentsTask.dependsOn(binary);
            }
        });
        binary.getTasks().create(namingScheme.getTaskName(BUILD_DEPENDENTS_TASK_NAME), DefaultTask.class, new Action<DefaultTask>(){

            @Override
            public void execute(DefaultTask buildDependentsTask) {
                buildDependentsTask.setGroup("Build Dependents");
                buildDependentsTask.setDescription("Build dependents of " + binary.getDisplayName() + ".");
                buildDependentsTask.dependsOn(binary);
            }
        });
    }

    public static void wireBuildDependentTasks(ModelMap<Task> tasks, BinaryContainer binaries, final DependentBinariesResolver dependentsResolver, final ProjectModelResolver projectModelResolver) {
        ModelMap<NativeBinarySpecInternal> nativeBinaries = binaries.withType(NativeBinarySpecInternal.class);
        for (final BinarySpecInternal binarySpecInternal : nativeBinaries) {
            Task buildDependentComponents;
            Task assembleDependents = tasks.get(binarySpecInternal.getNamingScheme().getTaskName(ASSEMBLE_DEPENDENTS_TASK_NAME));
            Task buildDependents = tasks.get(binarySpecInternal.getNamingScheme().getTaskName(BUILD_DEPENDENTS_TASK_NAME));
            Task assembleDependentComponents = tasks.get(NativeComponents.getAssembleDependentComponentsTaskName(binarySpecInternal.getComponent()));
            if (assembleDependentComponents != null) {
                assembleDependentComponents.dependsOn(assembleDependents);
            }
            if ((buildDependentComponents = tasks.get(NativeComponents.getBuildDependentComponentsTaskName(binarySpecInternal.getComponent()))) != null) {
                buildDependentComponents.dependsOn(buildDependents);
            }
            assembleDependents.dependsOn(new Callable<Iterable<Task>>(){

                @Override
                public Iterable<Task> call() {
                    return NativeComponents.getDependentTaskDependencies(NativeComponents.ASSEMBLE_DEPENDENTS_TASK_NAME, binarySpecInternal, dependentsResolver, projectModelResolver);
                }
            });
            buildDependents.dependsOn(new Callable<Iterable<Task>>(){

                @Override
                public Iterable<Task> call() {
                    return NativeComponents.getDependentTaskDependencies(NativeComponents.BUILD_DEPENDENTS_TASK_NAME, binarySpecInternal, dependentsResolver, projectModelResolver);
                }
            });
        }
    }

    private static List<Task> getDependentTaskDependencies(String dependedOnBinaryTaskName, BinarySpecInternal binary, DependentBinariesResolver dependentsResolver, ProjectModelResolver projectModelResolver) {
        ArrayList<Task> dependencies = Lists.newArrayList();
        DependentBinariesResolvedResult result = dependentsResolver.resolve(binary).getRoot();
        for (DependentBinariesResolvedResult dependent : result.getChildren()) {
            if (!dependent.isBuildable()) continue;
            ModelRegistry modelRegistry = projectModelResolver.resolveProjectModel(dependent.getId().getProjectPath());
            ModelMap<NativeBinarySpecInternal> projectBinaries = modelRegistry.realize("binaries", ModelTypes.modelMap(NativeBinarySpecInternal.class));
            ModelMap<Task> projectTasks = modelRegistry.realize("tasks", ModelTypes.modelMap(Task.class));
            NativeBinarySpecInternal dependentBinary = projectBinaries.get(dependent.getProjectScopedName());
            dependencies.add(projectTasks.get(dependentBinary.getNamingScheme().getTaskName(dependedOnBinaryTaskName)));
        }
        return dependencies;
    }

    private static String getAssembleDependentComponentsTaskName(ComponentSpec component) {
        return ASSEMBLE_DEPENDENTS_TASK_NAME + StringUtils.capitalize(component.getName());
    }

    private static String getBuildDependentComponentsTaskName(ComponentSpec component) {
        return BUILD_DEPENDENTS_TASK_NAME + StringUtils.capitalize(component.getName());
    }

    public static abstract class BinaryLibs
    implements Callable<List<FileCollection>> {
        private final NativeBinarySpec binary;

        public BinaryLibs(NativeBinarySpec binary) {
            this.binary = binary;
        }

        @Override
        public List<FileCollection> call() throws Exception {
            ArrayList<FileCollection> runtimeFiles = Lists.newArrayList();
            for (NativeDependencySet nativeDependencySet : this.binary.getLibs()) {
                runtimeFiles.add(this.getFiles(nativeDependencySet));
            }
            return runtimeFiles;
        }

        protected abstract FileCollection getFiles(NativeDependencySet var1);
    }
}

