/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.tasks;

import java.io.File;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.nativeplatform.toolchain.internal.PCHUtils;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

@Incubating
public class PrefixHeaderFileGenerateTask
extends DefaultTask {
    private String header;
    private File prefixHeaderFile;
    private final WorkerExecutor workerExecutor;

    @Inject
    public PrefixHeaderFileGenerateTask(WorkerExecutor workerExecutor) {
        this.workerExecutor = workerExecutor;
    }

    @TaskAction
    void generatePrefixHeaderFile() {
        WorkQueue workQueue = this.workerExecutor.noIsolation();
        workQueue.submit(GeneratePrefixHeaderFile.class, new Action<PrefixHeaderFileParameters>(){

            @Override
            public void execute(@Nonnull PrefixHeaderFileParameters parameters) {
                parameters.getHeader().set(PrefixHeaderFileGenerateTask.this.header);
                parameters.getPrefixHeaderFile().set(PrefixHeaderFileGenerateTask.this.prefixHeaderFile);
            }
        });
    }

    @Input
    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    @OutputFile
    public File getPrefixHeaderFile() {
        return this.prefixHeaderFile;
    }

    public void setPrefixHeaderFile(File prefixHeaderFile) {
        this.prefixHeaderFile = prefixHeaderFile;
    }

    static abstract class GeneratePrefixHeaderFile
    implements WorkAction<PrefixHeaderFileParameters> {
        @Inject
        public GeneratePrefixHeaderFile() {
        }

        @Override
        public void execute() {
            PCHUtils.generatePrefixHeaderFile(Lists.newArrayList((String)((PrefixHeaderFileParameters)this.getParameters()).getHeader().get()), ((PrefixHeaderFileParameters)this.getParameters()).getPrefixHeaderFile().getAsFile().get());
        }
    }

    static interface PrefixHeaderFileParameters
    extends WorkParameters {
        public Property<String> getHeader();

        public RegularFileProperty getPrefixHeaderFile();
    }
}

