/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.impldep.com.google.common.io.FileWriteMode;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.internal.impldep.org.apache.commons.io.FilenameUtils;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.nativeplatform.toolchain.internal.xcode.SwiftStdlibToolLocator;
import org.gradle.process.ExecSpec;
import org.gradle.util.GFileUtils;

public class InstallXCTestBundle
extends DefaultTask {
    private final DirectoryProperty installDirectory;
    private final RegularFileProperty bundleBinaryFile;

    public InstallXCTestBundle() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.installDirectory = objectFactory.directoryProperty();
        this.bundleBinaryFile = objectFactory.fileProperty();
        this.dependsOn(this.bundleBinaryFile);
    }

    @Inject
    protected SwiftStdlibToolLocator getSwiftStdlibToolLocator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileSystem getFileSystem() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileSystemOperations getFileSystemOperations() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    protected void install() throws IOException {
        File bundleFile = ((RegularFile)this.bundleBinaryFile.get()).getAsFile();
        File bundleDir = ((Directory)this.installDirectory.get()).file(bundleFile.getName() + ".xctest").getAsFile();
        this.installToDir(bundleDir, bundleFile);
        File runScript = this.getRunScriptFile().get().getAsFile();
        String runScriptText = "#!/bin/sh\nAPP_BASE_NAME=`dirname \"$0\"`\nXCTEST_LOCATION=`xcrun --find xctest`\nexec \"$XCTEST_LOCATION\" \"$@\" \"$APP_BASE_NAME/" + bundleDir.getName() + "\"\n";
        GFileUtils.writeFile(runScriptText, runScript);
        this.getFileSystem().chmod(runScript, 493);
    }

    private void installToDir(final File bundleDir, final File bundleFile) throws IOException {
        this.getFileSystemOperations().sync((Action<? super CopySpec>)new Action<CopySpec>(){

            @Override
            public void execute(CopySpec copySpec) {
                copySpec.from((Object)bundleFile, new Action<CopySpec>(){

                    @Override
                    public void execute(CopySpec copySpec) {
                        copySpec.into("Contents/MacOS");
                    }
                });
                copySpec.into(bundleDir);
            }
        });
        File outputFile = new File(bundleDir, "Contents/Info.plist");
        Files.asCharSink(outputFile, Charset.forName("UTF-8"), new FileWriteMode[0]).write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">\n<dict/>\n</plist>");
        this.getProject().exec((Action<? super ExecSpec>)new Action<ExecSpec>(){

            @Override
            public void execute(ExecSpec execSpec) {
                execSpec.setWorkingDir(bundleDir);
                execSpec.executable(InstallXCTestBundle.this.getSwiftStdlibToolLocator().find());
                execSpec.args("--copy", "--scan-executable", bundleFile.getAbsolutePath(), "--destination", new File(bundleDir, "Contents/Frameworks").getAbsolutePath(), "--platform", "macosx", "--resource-destination", new File(bundleDir, "Contents/Resources").getAbsolutePath(), "--scan-folder", new File(bundleDir, "Contents/Frameworks").getAbsolutePath());
            }
        }).assertNormalExitValue();
    }

    @Internal
    public Provider<RegularFile> getRunScriptFile() {
        return this.installDirectory.file(this.getProject().provider(new Callable<CharSequence>(){

            @Override
            public CharSequence call() throws Exception {
                return FilenameUtils.removeExtension(((RegularFile)InstallXCTestBundle.this.bundleBinaryFile.get()).getAsFile().getName());
            }
        }));
    }

    @Internal(value="covered by getBundleBinary()")
    public RegularFileProperty getBundleBinaryFile() {
        return this.bundleBinaryFile;
    }

    @SkipWhenEmpty
    @Nullable
    @Optional
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputFile
    protected File getBundleBinary() {
        RegularFile bundle = (RegularFile)this.getBundleBinaryFile().get();
        File bundleFile = bundle.getAsFile();
        if (!bundleFile.exists()) {
            return null;
        }
        return bundleFile;
    }

    @OutputDirectory
    public DirectoryProperty getInstallDirectory() {
        return this.installDirectory;
    }
}

