/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.gcc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.toolchain.internal.ArgsTransformer;
import org.gradle.nativeplatform.toolchain.internal.MacroArgsConverter;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;

abstract class GccCompilerArgsTransformer<T extends NativeCompileSpec>
implements ArgsTransformer<T> {
    GccCompilerArgsTransformer() {
    }

    @Override
    public List<String> transform(T spec) {
        ArrayList<String> args = Lists.newArrayList();
        this.addToolSpecificArgs(spec, args);
        this.addMacroArgs(spec, args);
        this.addUserArgs(spec, args);
        this.addIncludeArgs(spec, args);
        return args;
    }

    protected void addToolSpecificArgs(T spec, List<String> args) {
        Collections.addAll(args, "-x", this.getLanguage());
        args.add("-c");
        if (spec.isPositionIndependentCode() && !spec.getTargetPlatform().getOperatingSystem().isWindows()) {
            args.add("-fPIC");
        }
        if (spec.isDebuggable()) {
            args.add("-g");
        }
        if (spec.isOptimized()) {
            args.add("-O3");
        }
    }

    protected void addIncludeArgs(T spec, List<String> args) {
        if (!this.needsStandardIncludes(spec.getTargetPlatform())) {
            args.add("-nostdinc");
        }
        for (File file : spec.getIncludeRoots()) {
            args.add("-I");
            args.add(file.getAbsolutePath());
        }
        for (File file : spec.getSystemIncludeRoots()) {
            args.add("-isystem");
            args.add(file.getAbsolutePath());
        }
    }

    protected void addMacroArgs(T spec, List<String> args) {
        for (String macroArg : new MacroArgsConverter().transform(spec.getMacros())) {
            args.add("-D" + macroArg);
        }
    }

    protected void addUserArgs(T spec, List<String> args) {
        args.addAll(spec.getAllArgs());
    }

    protected boolean needsStandardIncludes(NativePlatform targetPlatform) {
        return targetPlatform.getOperatingSystem().isMacOsX();
    }

    protected abstract String getLanguage();
}

