/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.gcc.metadata;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.FileUtils;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.platform.internal.ArchitectureInternal;
import org.gradle.nativeplatform.platform.internal.Architectures;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.toolchain.internal.SystemLibraries;
import org.gradle.nativeplatform.toolchain.internal.gcc.metadata.GccCompilerType;
import org.gradle.nativeplatform.toolchain.internal.gcc.metadata.GccMetadata;
import org.gradle.nativeplatform.toolchain.internal.metadata.AbstractMetadataProvider;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerType;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.util.VersionNumber;

public class GccMetadataProvider
extends AbstractMetadataProvider<GccMetadata> {
    private static final Pattern DEFINE_PATTERN = Pattern.compile("\\s*#define\\s+(\\S+)\\s+(.*)");
    private static final String SYSTEM_INCLUDES_START = "#include <...> search starts here:";
    private static final String SYSTEM_INCLUDES_END = "End of search list.";
    private static final String FRAMEWORK_INCLUDE = " (framework directory)";
    private final GccCompilerType compilerType;

    public static GccMetadataProvider forGcc(ExecActionFactory execActionFactory) {
        return new GccMetadataProvider(execActionFactory, GccCompilerType.GCC);
    }

    public static GccMetadataProvider forClang(ExecActionFactory execActionFactory) {
        return new GccMetadataProvider(execActionFactory, GccCompilerType.CLANG);
    }

    GccMetadataProvider(ExecActionFactory execActionFactory, GccCompilerType compilerType) {
        super(execActionFactory);
        this.compilerType = compilerType;
    }

    @Override
    public CompilerType getCompilerType() {
        return this.compilerType;
    }

    @Override
    protected List<String> compilerArgs() {
        return ImmutableList.of("-dM", "-E", "-v", "-");
    }

    @Override
    protected GccMetadata parseCompilerOutput(String output, String error, File gccBinary, List<File> path) {
        Map<String, String> defines = this.parseDefines(output, gccBinary);
        VersionNumber scrapedVersion = this.determineVersion(defines, gccBinary);
        ArchitectureInternal architecture = this.determineArchitecture(defines);
        String scrapedVendor = this.determineVendor(error, scrapedVersion, gccBinary);
        ImmutableList<File> systemIncludes = this.determineSystemIncludes(defines, path, error);
        return new DefaultGccMetadata(scrapedVersion, scrapedVendor, architecture, systemIncludes);
    }

    private String determineVendor(String error, VersionNumber versionNumber, File gccBinary) {
        BufferedReader reader = new BufferedReader(new StringReader(error));
        String majorMinorOnly = versionNumber.getMajor() + "." + versionNumber.getMinor();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains(majorMinorOnly) || !line.contains(" version ") || !line.contains(this.compilerType.getIdentifier()) || line.contains(" default target ")) continue;
                return line;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        throw new AbstractMetadataProvider.BrokenResultException(String.format("Could not determine %s metadata: could not find vendor in output of %s.", this.compilerType.getDescription(), gccBinary));
    }

    private ImmutableList<File> determineSystemIncludes(Map<String, String> defines, List<File> path, String error) {
        File cygpathExe = null;
        boolean isCygwin = defines.containsKey("__CYGWIN__");
        if (isCygwin) {
            cygpathExe = this.findCygpath(path);
        }
        BufferedReader reader = new BufferedReader(new StringReader(error));
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean systemIncludesStarted = false;
        try {
            String line;
            while ((line = reader.readLine()) != null && !SYSTEM_INCLUDES_END.equals(line)) {
                if (SYSTEM_INCLUDES_START.equals(line)) {
                    systemIncludesStarted = true;
                    continue;
                }
                if (!systemIncludesStarted || this.compilerType == GccCompilerType.CLANG && line.contains(FRAMEWORK_INCLUDE) || this.compilerType == GccCompilerType.GCC && line.endsWith("/Library/Frameworks")) continue;
                String include = line.trim();
                if (isCygwin) {
                    include = this.mapCygwinPath(cygpathExe, include);
                }
                builder.add(FileUtils.normalize(new File(include)));
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private File findCygpath(List<File> path) {
        for (File dir2 : path) {
            File exe = new File(dir2, OperatingSystem.current().getExecutableName("cygpath"));
            if (!exe.exists()) continue;
            return exe;
        }
        File exe = OperatingSystem.current().findInPath("cygpath");
        if (exe != null) {
            return exe;
        }
        throw new IllegalStateException("Could not find 'cygpath' executable in path: " + Joiner.on(File.pathSeparator).join(path));
    }

    private String mapCygwinPath(File cygpathExe, String cygwinPath) {
        ExecAction execAction = this.getExecActionFactory().newExecAction();
        execAction.setWorkingDir(new File(".").getAbsolutePath());
        execAction.commandLine(cygpathExe.getAbsolutePath(), "-w", cygwinPath);
        StreamByteBuffer buffer = new StreamByteBuffer();
        StreamByteBuffer errorBuffer = new StreamByteBuffer();
        execAction.setStandardOutput(buffer.getOutputStream());
        execAction.setErrorOutput(errorBuffer.getOutputStream());
        execAction.execute().assertNormalExitValue();
        return buffer.readAsString().trim();
    }

    private Map<String, String> parseDefines(String output, File gccBinary) {
        BufferedReader reader = new BufferedReader(new StringReader(output));
        HashMap<String, String> defines = new HashMap<String, String>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher matcher = DEFINE_PATTERN.matcher(line);
                if (!matcher.matches()) {
                    throw new AbstractMetadataProvider.BrokenResultException(String.format("Could not determine %s metadata: %s produced unexpected output.", this.compilerType.getDescription(), gccBinary.getName()));
                }
                defines.put(matcher.group(1), matcher.group(2));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (!defines.containsKey("__GNUC__") && !defines.containsKey("__clang__")) {
            throw new AbstractMetadataProvider.BrokenResultException(String.format("Could not determine %s metadata: %s produced unexpected output.", this.compilerType.getDescription(), gccBinary.getName()));
        }
        return defines;
    }

    private VersionNumber determineVersion(Map<String, String> defines, File gccBinary) {
        int patch;
        int minor;
        int major;
        switch (this.compilerType) {
            case CLANG: {
                if (!defines.containsKey("__clang__")) {
                    throw new AbstractMetadataProvider.BrokenResultException(String.format("%s appears to be GCC rather than Clang. Treating it as GCC.", gccBinary.getName()));
                }
                major = this.toInt(defines.get("__clang_major__"));
                minor = this.toInt(defines.get("__clang_minor__"));
                patch = this.toInt(defines.get("__clang_patchlevel__"));
                break;
            }
            case GCC: {
                if (defines.containsKey("__clang__")) {
                    throw new AbstractMetadataProvider.BrokenResultException(String.format("XCode %s is a wrapper around Clang. Treating it as Clang and not GCC.", gccBinary.getName()));
                }
                major = this.toInt(defines.get("__GNUC__"));
                minor = this.toInt(defines.get("__GNUC_MINOR__"));
                patch = this.toInt(defines.get("__GNUC_PATCHLEVEL__"));
                break;
            }
            default: {
                throw new GradleException("Unknown compiler type " + this.compilerType);
            }
        }
        return new VersionNumber(major, minor, patch, null);
    }

    private ArchitectureInternal determineArchitecture(Map<String, String> defines) {
        boolean i386 = defines.containsKey("__i386__");
        boolean amd64 = defines.containsKey("__amd64__");
        ArchitectureInternal architecture = i386 ? Architectures.forInput("i386") : (amd64 ? Architectures.forInput("amd64") : DefaultNativePlatform.getCurrentArchitecture());
        return architecture;
    }

    private int toInt(String value) {
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static class DefaultGccMetadata
    implements GccMetadata,
    SystemLibraries {
        private final VersionNumber scrapedVersion;
        private final String scrapedVendor;
        private final ArchitectureInternal architecture;
        private final ImmutableList<File> systemIncludes;

        DefaultGccMetadata(VersionNumber scrapedVersion, String scrapedVendor, ArchitectureInternal architecture, ImmutableList<File> systemIncludes) {
            this.scrapedVersion = scrapedVersion;
            this.scrapedVendor = scrapedVendor;
            this.architecture = architecture;
            this.systemIncludes = systemIncludes;
        }

        @Override
        public VersionNumber getVersion() {
            return this.scrapedVersion;
        }

        @Override
        public SystemLibraries getSystemLibraries() {
            return this;
        }

        @Override
        public List<File> getIncludeDirs() {
            return this.systemIncludes;
        }

        @Override
        public List<File> getLibDirs() {
            return Collections.emptyList();
        }

        @Override
        public Map<String, String> getPreprocessorMacros() {
            return Collections.emptyMap();
        }

        @Override
        public ArchitectureInternal getDefaultArchitecture() {
            return this.architecture;
        }

        @Override
        public String getVendor() {
            return this.scrapedVendor;
        }
    }
}

