/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.rubygrapefruit.platform.MissingRegistryEntryException;
import net.rubygrapefruit.platform.WindowsRegistry;
import org.gradle.api.Transformer;
import org.gradle.internal.FileUtils;
import org.gradle.internal.impldep.com.google.common.collect.HashMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.SetMultimap;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsComponentLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsKitInstall;
import org.gradle.platform.base.internal.toolchain.ComponentFound;
import org.gradle.platform.base.internal.toolchain.ComponentNotFound;
import org.gradle.platform.base.internal.toolchain.SearchResult;
import org.gradle.util.CollectionUtils;
import org.gradle.util.VersionNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWindowsKitComponentLocator<T extends WindowsKitInstall>
implements WindowsComponentLocator<T> {
    static final String[] PLATFORMS = new String[]{"x86", "x64"};
    private static final String USER_PROVIDED = "User-provided";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWindowsKitComponentLocator.class);
    private final SetMultimap<File, T> foundComponents = HashMultimap.create();
    private final Set<File> brokenComponents = new LinkedHashSet<File>();
    private final WindowsRegistry windowsRegistry;
    private boolean initialised;
    private static final String[] REGISTRY_BASEPATHS = new String[]{"SOFTWARE\\", "SOFTWARE\\Wow6432Node\\"};
    private static final String REGISTRY_ROOTPATH_KIT = "Microsoft\\Windows Kits\\Installed Roots";
    private static final String REGISTRY_KIT_10 = "KitsRoot10";
    private final Pattern windowsKitVersionPattern = Pattern.compile("[0-9]+(\\.[0-9]+)*");
    private final FileFilter windowsKitVersionFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            Matcher matcher = AbstractWindowsKitComponentLocator.this.windowsKitVersionPattern.matcher(pathname.getName());
            return pathname.isDirectory() && matcher.matches();
        }
    };

    AbstractWindowsKitComponentLocator(WindowsRegistry windowsRegistry) {
        this.windowsRegistry = windowsRegistry;
    }

    @Override
    public SearchResult<T> locateComponent(File candidate) {
        this.initializeComponents();
        if (candidate != null) {
            return this.locateUserSpecifiedComponent(candidate);
        }
        return this.locateDefaultComponent();
    }

    @Override
    public List<T> locateAllComponents() {
        this.initializeComponents();
        return Lists.newArrayList(this.foundComponents.values());
    }

    private void initializeComponents() {
        if (!this.initialised) {
            this.locateComponentsInRegistry();
            this.initialised = true;
        }
    }

    private SearchResult<T> locateDefaultComponent() {
        T selected = this.getBestComponent();
        if (selected != null) {
            return new ComponentFound<T>(selected);
        }
        if (this.brokenComponents.isEmpty()) {
            return new ComponentNotFound("Could not locate a " + this.getDisplayName() + " installation using the Windows registry.");
        }
        return new ComponentNotFound("Could not locate a " + this.getDisplayName() + " installation. None of the following locations contain a valid installation", CollectionUtils.collect(this.brokenComponents, new Transformer<String, File>(){

            @Override
            public String transform(File file) {
                return file.getAbsolutePath();
            }
        }));
    }

    private T getBestComponent() {
        TreeSet candidates = new TreeSet(new DescendingComponentVersionComparator());
        candidates.addAll(this.foundComponents.values());
        return (T)(candidates.isEmpty() ? null : (WindowsKitInstall)candidates.iterator().next());
    }

    private void locateComponentsInRegistry() {
        for (String baseKey : REGISTRY_BASEPATHS) {
            this.locateComponentsInRegistry(baseKey);
        }
    }

    private void locateComponentsInRegistry(String baseKey) {
        try {
            File windowsKitDir = FileUtils.canonicalize(new File(this.windowsRegistry.getStringValue(WindowsRegistry.Key.HKEY_LOCAL_MACHINE, baseKey + REGISTRY_ROOTPATH_KIT, REGISTRY_KIT_10)));
            Set<T> found = this.findIn(windowsKitDir, DiscoveryType.REGISTRY);
            if (found.isEmpty()) {
                this.brokenComponents.add(windowsKitDir);
            }
            for (WindowsKitInstall t : found) {
                this.foundComponents.put(t.getBaseDir(), t);
            }
        }
        catch (MissingRegistryEntryException missingRegistryEntryException) {
            // empty catch block
        }
    }

    private Set<T> findIn(File windowsKitDir, DiscoveryType discoveryType) {
        String[] versionDirs;
        LinkedHashSet<T> found = new LinkedHashSet<T>();
        for (String versionDir : versionDirs = this.getComponentVersionDirs(windowsKitDir)) {
            T component;
            VersionNumber version = VersionNumber.withPatchNumber().parse(versionDir);
            LOGGER.debug("Found {} {} at {}", this.getDisplayName(), version.toString(), windowsKitDir);
            File binDir = new File(windowsKitDir, "bin/" + versionDir);
            File unversionedBinDir = new File(windowsKitDir, "bin");
            if (this.isValidComponentBinDir(binDir)) {
                component = this.newComponent(windowsKitDir, binDir, version, discoveryType);
                found.add(component);
                continue;
            }
            if (!this.isValidComponentBinDir(unversionedBinDir)) continue;
            component = this.newComponent(windowsKitDir, unversionedBinDir, version, discoveryType);
            found.add(component);
        }
        if (found.isEmpty()) {
            LOGGER.debug("Ignoring candidate directory {} as it does not look like a {} installation.", (Object)windowsKitDir, (Object)this.getDisplayName());
        }
        return found;
    }

    private SearchResult<T> locateUserSpecifiedComponent(File candidate) {
        File windowsKitDir = FileUtils.canonicalize(candidate);
        Set<T> candidates = this.foundComponents.get(windowsKitDir);
        if (candidates.isEmpty()) {
            candidates = this.findIn(windowsKitDir, DiscoveryType.USER);
        }
        if (candidates.isEmpty()) {
            return new ComponentNotFound(String.format("The specified installation directory '%s' does not appear to contain a %s installation.", candidate, this.getDisplayName()));
        }
        TreeSet<T> found = new TreeSet<T>(new DescendingComponentVersionComparator());
        found.addAll(candidates);
        return new ComponentFound<WindowsKitInstall>((WindowsKitInstall)found.iterator().next());
    }

    private String[] getComponentVersionDirs(File candidate) {
        File includeDir = new File(candidate, "Include");
        File libDir = new File(candidate, "Lib");
        if (!includeDir.isDirectory() || !libDir.isDirectory()) {
            return new String[0];
        }
        HashMap<String, File> includeDirs = new HashMap<String, File>();
        for (File dir2 : includeDir.listFiles(this.windowsKitVersionFilter)) {
            includeDirs.put(dir2.getName(), dir2);
        }
        HashMap<String, File> libDirs = new HashMap<String, File>();
        for (File dir3 : libDir.listFiles(this.windowsKitVersionFilter)) {
            libDirs.put(dir3.getName(), dir3);
        }
        HashSet kitVersions = new HashSet();
        kitVersions.addAll(includeDirs.keySet());
        kitVersions.addAll(libDirs.keySet());
        ArrayList<String> result = new ArrayList<String>();
        for (String version : kitVersions) {
            File inc = (File)includeDirs.get(version);
            File lib = (File)libDirs.get(version);
            if (inc == null || lib == null) continue;
            File componentInc = new File(inc, this.getComponentName());
            File componentLib = new File(lib, this.getComponentName());
            if (!this.isValidComponentIncludeDir(componentInc) || !this.isValidComponentLibDir(componentLib)) continue;
            result.add(version);
        }
        return result.toArray(new String[result.size()]);
    }

    protected String getVersionedDisplayName(VersionNumber version, DiscoveryType discoveryType) {
        switch (discoveryType) {
            case USER: {
                return "User-provided " + this.getDisplayName() + " " + version.getMajor();
            }
            case REGISTRY: {
                return this.getDisplayName() + " " + version.getMajor();
            }
        }
        throw new IllegalArgumentException("Unknown discovery method for " + this.getDisplayName() + ": " + (Object)((Object)discoveryType));
    }

    abstract String getComponentName();

    abstract String getDisplayName();

    abstract boolean isValidComponentBinDir(File var1);

    abstract boolean isValidComponentIncludeDir(File var1);

    abstract boolean isValidComponentLibDir(File var1);

    abstract T newComponent(File var1, File var2, VersionNumber var3, DiscoveryType var4);

    private class DescendingComponentVersionComparator
    implements Comparator<T> {
        private DescendingComponentVersionComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            return ((WindowsKitInstall)o2).getVersion().compareTo(((WindowsKitInstall)o1).getVersion());
        }
    }

    protected static enum DiscoveryType {
        REGISTRY,
        USER;

    }
}

