/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.nativeplatform.toolchain.internal.ArgsTransformer;
import org.gradle.nativeplatform.toolchain.internal.MacroArgsConverter;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.EscapeUserArgs;

abstract class VisualCppCompilerArgsTransformer<T extends NativeCompileSpec>
implements ArgsTransformer<T> {
    VisualCppCompilerArgsTransformer() {
    }

    @Override
    public List<String> transform(T spec) {
        ArrayList<String> args = Lists.newArrayList();
        this.addToolSpecificArgs(spec, args);
        this.addMacroArgs(spec, args);
        this.addUserArgs(spec, args);
        this.addIncludeArgs(spec, args);
        return args;
    }

    private void addUserArgs(T spec, List<String> args) {
        args.addAll(EscapeUserArgs.escapeUserArgs(spec.getAllArgs()));
    }

    protected void addToolSpecificArgs(T spec, List<String> args) {
        args.add(this.getLanguageOption());
        args.add("/nologo");
        args.add("/c");
        if (spec.isDebuggable()) {
            args.add("/Zi");
        }
        if (spec.isOptimized()) {
            args.add("/O2");
        }
    }

    protected void addIncludeArgs(T spec, List<String> args) {
        for (File file : spec.getIncludeRoots()) {
            args.add("/I" + file.getAbsolutePath());
        }
        for (File file : spec.getSystemIncludeRoots()) {
            args.add("/I" + file.getAbsolutePath());
        }
    }

    protected void addMacroArgs(T spec, List<String> args) {
        for (String macroArg : new MacroArgsConverter().transform(spec.getMacros())) {
            args.add(EscapeUserArgs.escapeUserArg("/D" + macroArg));
        }
    }

    protected String getLanguageOption() {
        return "";
    }
}

