/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import groovy.util.Node;
import java.util.LinkedHashMap;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.plugins.ide.eclipse.model.WbModuleEntry;
import org.gradle.plugins.ide.eclipse.model.internal.PathUtil;

public class WbDependentModule
implements WbModuleEntry {
    private String deployPath;
    private String handle;

    public WbDependentModule(Node node) {
        this((String)node.attribute((Object)"deploy-path"), (String)node.attribute((Object)"handle"));
    }

    public WbDependentModule(String deployPath, String handle) {
        Preconditions.checkNotNull(deployPath);
        this.deployPath = PathUtil.normalizePath(deployPath);
        this.handle = Preconditions.checkNotNull(handle);
    }

    public String getDeployPath() {
        return this.deployPath;
    }

    public void setDeployPath(String deployPath) {
        this.deployPath = deployPath;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    @Override
    public void appendNode(Node parentNode) {
        LinkedHashMap<String, String> attributes = Maps.newLinkedHashMap();
        attributes.put("deploy-path", this.deployPath);
        attributes.put("handle", this.handle);
        Node node = parentNode.appendNode((Object)"dependent-module", attributes);
        node.appendNode((Object)"dependency-type").setValue((Object)"uses");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        WbDependentModule that = (WbDependentModule)o;
        return Objects.equal(this.deployPath, that.deployPath) && Objects.equal(this.handle, that.handle);
    }

    public int hashCode() {
        int result = this.deployPath.hashCode();
        result = 31 * result + this.handle.hashCode();
        return result;
    }

    public String toString() {
        return "WbDependentModule{deployPath='" + this.deployPath + "', handle='" + this.handle + "'}";
    }
}

