/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.jvm.ModularitySpec;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.jvm.DefaultModularitySpec;
import org.gradle.internal.jvm.JavaModuleDetector;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.JavaDebugOptions;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.AbstractExecHandleBuilder;
import org.gradle.process.internal.ProcessArgumentsSpec;
import org.gradle.process.internal.util.LongCommandLineDetectionUtil;
import org.gradle.util.CollectionUtils;

public class JavaExecHandleBuilder
extends AbstractExecHandleBuilder
implements JavaExecSpec,
ProcessArgumentsSpec.HasExecutable {
    private static final Logger LOGGER = Logging.getLogger(JavaExecHandleBuilder.class);
    private final FileCollectionFactory fileCollectionFactory;
    private final TemporaryFileProvider temporaryFileProvider;
    private final JavaModuleDetector javaModuleDetector;
    private final Property<String> mainModule;
    private final Property<String> mainClass;
    private ConfigurableFileCollection classpath;
    private final JavaForkOptions javaOptions;
    private final ProcessArgumentsSpec applicationArgsSpec = new ProcessArgumentsSpec(this);
    private final ModularitySpec modularity;

    public JavaExecHandleBuilder(FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, ObjectFactory objectFactory, Executor executor, BuildCancellationToken buildCancellationToken, TemporaryFileProvider temporaryFileProvider, @Nullable JavaModuleDetector javaModuleDetector, JavaForkOptions javaOptions) {
        super(fileResolver, executor, buildCancellationToken);
        this.fileCollectionFactory = fileCollectionFactory;
        this.temporaryFileProvider = temporaryFileProvider;
        this.javaModuleDetector = javaModuleDetector;
        this.classpath = fileCollectionFactory.configurableFiles("classpath");
        this.mainModule = objectFactory.property(String.class);
        this.mainClass = objectFactory.property(String.class);
        this.javaOptions = javaOptions;
        this.modularity = new DefaultModularitySpec(objectFactory);
        this.executable(javaOptions.getExecutable());
    }

    @Override
    public List<String> getAllJvmArgs() {
        return this.getAllJvmArgs(this.classpath);
    }

    private List<String> getAllJvmArgs(FileCollection realClasspath) {
        boolean runAsModule;
        ArrayList<String> allArgs = new ArrayList<String>(this.javaOptions.getAllJvmArgs());
        boolean bl = runAsModule = (Boolean)this.modularity.getInferModulePath().get() != false && this.mainModule.isPresent();
        if (runAsModule) {
            this.addModularJavaRunArgs(realClasspath, allArgs);
        } else {
            this.addClassicJavaRunArgs(realClasspath, allArgs);
        }
        return allArgs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addClassicJavaRunArgs(FileCollection classpath, List<String> allArgs) {
        if (!this.mainClass.isPresent()) {
            if (classpath == null || classpath.getFiles().size() != 1) throw new IllegalStateException("No main class specified and classpath is not an executable jar.");
            allArgs.add("-jar");
            allArgs.add(classpath.getSingleFile().getAbsolutePath());
            return;
        } else {
            if (classpath != null && !classpath.isEmpty()) {
                allArgs.add("-cp");
                allArgs.add(CollectionUtils.join(File.pathSeparator, classpath));
            }
            allArgs.add((String)this.mainClass.get());
        }
    }

    private void addModularJavaRunArgs(FileCollection classpath, List<String> allArgs) {
        if (this.javaModuleDetector == null) {
            throw new IllegalStateException("Running a Java module is not supported in this context.");
        }
        FileCollection rtModulePath = this.javaModuleDetector.inferModulePath((boolean)((Boolean)this.modularity.getInferModulePath().get()), classpath);
        FileCollection rtClasspath = this.javaModuleDetector.inferClasspath((boolean)((Boolean)this.modularity.getInferModulePath().get()), classpath);
        if (rtClasspath != null && !rtClasspath.isEmpty()) {
            allArgs.add("-cp");
            allArgs.add(CollectionUtils.join(File.pathSeparator, rtClasspath));
        }
        if (rtModulePath != null && !rtModulePath.isEmpty()) {
            allArgs.add("--module-path");
            allArgs.add(CollectionUtils.join(File.pathSeparator, rtModulePath));
        }
        allArgs.add("--module");
        if (!this.mainClass.isPresent()) {
            allArgs.add((String)this.mainModule.get());
        } else {
            allArgs.add((String)this.mainModule.get() + "/" + (String)this.mainClass.get());
        }
    }

    @Override
    public void setAllJvmArgs(List<String> arguments) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAllJvmArgs(Iterable<?> arguments) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getJvmArgs() {
        return this.javaOptions.getJvmArgs();
    }

    @Override
    public void setJvmArgs(List<String> arguments) {
        this.javaOptions.setJvmArgs(arguments);
    }

    @Override
    public void setJvmArgs(Iterable<?> arguments) {
        this.javaOptions.setJvmArgs(arguments);
    }

    @Override
    public JavaExecHandleBuilder jvmArgs(Iterable<?> arguments) {
        this.javaOptions.jvmArgs(arguments);
        return this;
    }

    @Override
    public JavaExecHandleBuilder jvmArgs(Object ... arguments) {
        this.javaOptions.jvmArgs(arguments);
        return this;
    }

    @Override
    public Map<String, Object> getSystemProperties() {
        return this.javaOptions.getSystemProperties();
    }

    @Override
    public void setSystemProperties(Map<String, ?> properties) {
        this.javaOptions.setSystemProperties(properties);
    }

    @Override
    public JavaExecHandleBuilder systemProperties(Map<String, ?> properties) {
        this.javaOptions.systemProperties(properties);
        return this;
    }

    @Override
    public JavaExecHandleBuilder systemProperty(String name, Object value) {
        this.javaOptions.systemProperty(name, value);
        return this;
    }

    @Override
    public FileCollection getBootstrapClasspath() {
        return this.javaOptions.getBootstrapClasspath();
    }

    @Override
    public void setBootstrapClasspath(FileCollection classpath) {
        this.javaOptions.setBootstrapClasspath(classpath);
    }

    @Override
    public JavaForkOptions bootstrapClasspath(Object ... classpath) {
        this.javaOptions.bootstrapClasspath(classpath);
        return this;
    }

    @Override
    public String getMinHeapSize() {
        return this.javaOptions.getMinHeapSize();
    }

    @Override
    public void setMinHeapSize(String heapSize) {
        this.javaOptions.setMinHeapSize(heapSize);
    }

    @Override
    public String getDefaultCharacterEncoding() {
        return this.javaOptions.getDefaultCharacterEncoding();
    }

    @Override
    public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
        this.javaOptions.setDefaultCharacterEncoding(defaultCharacterEncoding);
    }

    @Override
    public String getMaxHeapSize() {
        return this.javaOptions.getMaxHeapSize();
    }

    @Override
    public void setMaxHeapSize(String heapSize) {
        this.javaOptions.setMaxHeapSize(heapSize);
    }

    @Override
    public boolean getEnableAssertions() {
        return this.javaOptions.getEnableAssertions();
    }

    @Override
    public void setEnableAssertions(boolean enabled) {
        this.javaOptions.setEnableAssertions(enabled);
    }

    @Override
    public boolean getDebug() {
        return this.javaOptions.getDebug();
    }

    @Override
    public void setDebug(boolean enabled) {
        this.javaOptions.setDebug(enabled);
    }

    @Override
    public JavaDebugOptions getDebugOptions() {
        return this.javaOptions.getDebugOptions();
    }

    @Override
    public void debugOptions(Action<JavaDebugOptions> action) {
        this.javaOptions.debugOptions(action);
    }

    @Override
    public Property<String> getMainModule() {
        return this.mainModule;
    }

    @Override
    public Property<String> getMainClass() {
        return this.mainClass;
    }

    @Override
    public String getMain() {
        return (String)this.mainClass.getOrNull();
    }

    @Override
    public JavaExecHandleBuilder setMain(String mainClassName) {
        this.mainClass.set(mainClassName);
        return this;
    }

    @Override
    @Nonnull
    public List<String> getArgs() {
        return this.applicationArgsSpec.getArgs();
    }

    @Override
    public JavaExecHandleBuilder setArgs(List<String> applicationArgs) {
        this.applicationArgsSpec.setArgs(applicationArgs);
        return this;
    }

    @Override
    public JavaExecHandleBuilder setArgs(Iterable<?> applicationArgs) {
        this.applicationArgsSpec.setArgs(applicationArgs);
        return this;
    }

    @Override
    public JavaExecHandleBuilder args(Object ... args) {
        this.applicationArgsSpec.args(args);
        return this;
    }

    @Override
    public JavaExecSpec args(Iterable<?> args) {
        this.applicationArgsSpec.args(args);
        return this;
    }

    @Override
    public List<CommandLineArgumentProvider> getArgumentProviders() {
        return this.applicationArgsSpec.getArgumentProviders();
    }

    @Override
    public JavaExecHandleBuilder setClasspath(FileCollection classpath) {
        ConfigurableFileCollection newClasspath = this.fileCollectionFactory.configurableFiles("classpath");
        newClasspath.setFrom(classpath);
        this.classpath = newClasspath;
        return this;
    }

    @Override
    public ModularitySpec getModularity() {
        return this.modularity;
    }

    @Override
    public JavaExecHandleBuilder classpath(Object ... paths) {
        this.classpath.from(paths);
        return this;
    }

    @Override
    public FileCollection getClasspath() {
        return this.classpath;
    }

    @Override
    public List<String> getAllArguments() {
        return this.getAllArguments(this.classpath);
    }

    private List<String> getAllArguments(FileCollection realClasspath) {
        ArrayList<String> arguments = new ArrayList<String>(this.getAllJvmArgs(realClasspath));
        arguments.addAll(this.applicationArgsSpec.getAllArguments());
        return arguments;
    }

    @Override
    protected List<String> getEffectiveArguments() {
        List<String> arguments = this.getAllArguments();
        if (LongCommandLineDetectionUtil.hasCommandLineExceedMaxLength(this.getExecutable(), arguments)) {
            try {
                File pathingJarFile = this.writePathingJarFile(this.classpath);
                ConfigurableFileCollection shortenedClasspath = this.fileCollectionFactory.configurableFiles();
                shortenedClasspath.from(pathingJarFile);
                List<String> shortenedArguments = this.getAllArguments(shortenedClasspath);
                LOGGER.info("Shortening Java classpath {} with {}", (Object)this.classpath.getFiles(), (Object)pathingJarFile);
                return shortenedArguments;
            }
            catch (IOException e) {
                LOGGER.info("Pathing JAR could not be created, Gradle cannot shorten the command line.", e);
            }
        }
        return arguments;
    }

    private File writePathingJarFile(FileCollection classPath) throws IOException {
        File pathingJarFile = this.temporaryFileProvider.createTemporaryFile("gradle-javaexec-classpath", ".jar", new String[0]);
        try (FileOutputStream fileOutputStream = new FileOutputStream(pathingJarFile);
             JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)fileOutputStream, JavaExecHandleBuilder.toManifest(classPath));){
            jarOutputStream.putNextEntry(new ZipEntry("META-INF/"));
        }
        return pathingJarFile;
    }

    private static Manifest toManifest(FileCollection classPath) {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.putValue("Class-Path", classPath.getFiles().stream().map(File::toURI).map(URI::toString).collect(Collectors.joining(" ")));
        return manifest;
    }

    @Override
    public JavaForkOptions copyTo(JavaForkOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JavaExecHandleBuilder setIgnoreExitValue(boolean ignoreExitValue) {
        super.setIgnoreExitValue(ignoreExitValue);
        return this;
    }

    @Override
    public List<CommandLineArgumentProvider> getJvmArgumentProviders() {
        return this.javaOptions.getJvmArgumentProviders();
    }
}

