/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.security.internal;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKey;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.gradle.security.internal.Fingerprint;
import org.gradle.security.internal.PublicKeyResultBuilder;
import org.gradle.security.internal.PublicKeyService;
import org.gradle.security.internal.SecuritySupport;

public class KeyringFilePublicKeyService
implements PublicKeyService {
    private static final Logger LOGGER = Logging.getLogger(KeyringFilePublicKeyService.class);
    private final Map<Fingerprint, PGPPublicKeyRing> keyToKeyring;
    private final Multimap<Long, PGPPublicKeyRing> longIdToPublicKeys;

    public KeyringFilePublicKeyService(File keyRingFile) {
        try {
            List<PGPPublicKeyRing> keyrings = SecuritySupport.loadKeyRingFile(keyRingFile);
            HashMap<Fingerprint, PGPPublicKeyRing> keyToKeyringBuilder = Maps.newHashMap();
            ImmutableListMultimap.Builder<Long, PGPPublicKeyRing> longIdLongPGPPublicKeyBuilder = ImmutableListMultimap.builder();
            for (PGPPublicKeyRing keyring : keyrings) {
                Iterator<PGPPublicKey> it = keyring.getPublicKeys();
                while (it.hasNext()) {
                    PGPPublicKey key = it.next();
                    Fingerprint fingerprint = Fingerprint.of(key);
                    keyToKeyringBuilder.put(fingerprint, keyring);
                    ((ImmutableMultimap.Builder)longIdLongPGPPublicKeyBuilder).put(key.getKeyID(), keyring);
                }
            }
            this.keyToKeyring = ImmutableMap.copyOf(keyToKeyringBuilder);
            this.longIdToPublicKeys = ((ImmutableMultimap.Builder)longIdLongPGPPublicKeyBuilder).build();
            LOGGER.info("Loaded {} keys from {}", (Object)this.keyToKeyring.size(), (Object)keyRingFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void findByLongId(long keyId, PublicKeyResultBuilder builder) {
        for (PGPPublicKeyRing keyring : this.longIdToPublicKeys.get(keyId)) {
            builder.keyRing(keyring);
            Iterator<PGPPublicKey> pkIt = keyring.getPublicKeys();
            while (pkIt.hasNext()) {
                PGPPublicKey key = pkIt.next();
                if (key.getKeyID() != keyId) continue;
                builder.publicKey(key);
            }
        }
    }

    @Override
    public void findByFingerprint(byte[] bytes, PublicKeyResultBuilder builder) {
        Fingerprint fingerprint = Fingerprint.wrap(bytes);
        PGPPublicKeyRing keyring = this.keyToKeyring.get(fingerprint);
        if (keyring != null) {
            builder.keyRing(keyring);
            Iterator<PGPPublicKey> pkIt = keyring.getPublicKeys();
            while (pkIt.hasNext()) {
                PGPPublicKey key = pkIt.next();
                if (!Arrays.equals(key.getFingerprint(), bytes)) continue;
                builder.publicKey(key);
            }
        }
    }
}

