/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.security.internal;

import java.util.List;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKey;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.gradle.security.internal.PublicKeyResultBuilder;
import org.gradle.security.internal.PublicKeyService;

public class PublicKeyServiceChain
implements PublicKeyService {
    private static final Logger LOGGER = Logging.getLogger(PublicKeyServiceChain.class);
    private final List<PublicKeyService> services;

    public static PublicKeyService of(PublicKeyService ... delegates) {
        return new PublicKeyServiceChain(ImmutableList.copyOf(delegates));
    }

    private PublicKeyServiceChain(List<PublicKeyService> services) {
        this.services = services;
    }

    @Override
    public void findByLongId(long keyId, PublicKeyResultBuilder builder) {
        FirstMatchBuilder fmb = new FirstMatchBuilder(builder);
        for (PublicKeyService service : this.services) {
            service.findByLongId(keyId, fmb);
            if (!fmb.hasResult) continue;
            return;
        }
    }

    @Override
    public void findByFingerprint(byte[] fingerprint, PublicKeyResultBuilder builder) {
        FirstMatchBuilder fmb = new FirstMatchBuilder(builder);
        for (PublicKeyService service : this.services) {
            service.findByFingerprint(fingerprint, fmb);
            if (!fmb.hasResult) continue;
            return;
        }
    }

    @Override
    public void close() {
        for (PublicKeyService service : this.services) {
            try {
                service.close();
            }
            catch (Exception e) {
                LOGGER.warn("Cannot close service", e);
            }
        }
    }

    private static class FirstMatchBuilder
    implements PublicKeyResultBuilder {
        private final PublicKeyResultBuilder delegate;
        public boolean hasResult;

        private FirstMatchBuilder(PublicKeyResultBuilder delegate) {
            this.delegate = delegate;
        }

        @Override
        public void keyRing(PGPPublicKeyRing keyring) {
            this.delegate.keyRing(keyring);
            this.hasResult = true;
        }

        @Override
        public void publicKey(PGPPublicKey publicKey) {
            this.delegate.publicKey(publicKey);
            this.hasResult = true;
        }
    }
}

