/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.git.internal;

import java.util.List;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Splitter;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Ref;
import org.gradle.vcs.internal.VersionRef;

public class GitVersionRef
implements VersionRef {
    private final String version;
    private final String canonicalId;

    private GitVersionRef(String version, String canonicalId) {
        this.version = version;
        this.canonicalId = canonicalId;
    }

    public static GitVersionRef from(Ref ref) {
        ObjectId commitId = ref.getPeeledObjectId() == null ? ref.getObjectId() : ref.getPeeledObjectId();
        return new GitVersionRef(GitVersionRef.extractName(ref), commitId.getName());
    }

    public static GitVersionRef from(String version, String canonicalId) {
        return new GitVersionRef(version, canonicalId);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getCanonicalId() {
        return this.canonicalId;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        GitVersionRef other = (GitVersionRef)obj;
        return Objects.equal(this.version, other.version) && Objects.equal(this.canonicalId, other.canonicalId);
    }

    public int hashCode() {
        return Objects.hashCode(this.version, this.canonicalId);
    }

    public String toString() {
        return this.version + ": " + this.canonicalId;
    }

    private static String extractName(Ref ref) {
        List<String> parts = Splitter.on("/").splitToList(ref.getName());
        return parts.get(parts.size() - 1);
    }
}

