/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.vcs.VersionControlSpec;
import org.gradle.vcs.internal.VcsMappingInternal;
import org.gradle.vcs.internal.VersionControlSpecFactory;

public class DefaultVcsMapping
implements VcsMappingInternal {
    private final ComponentSelector requested;
    private final VersionControlSpecFactory specFactory;
    private VersionControlSpec versionControlSpec;

    @Inject
    public DefaultVcsMapping(ComponentSelector requested, VersionControlSpecFactory specFactory) {
        this.requested = requested;
        this.specFactory = specFactory;
    }

    @Override
    public ComponentSelector getRequested() {
        return this.requested;
    }

    @Override
    public void from(VersionControlSpec versionControlSpec) {
        Preconditions.checkNotNull(versionControlSpec, "VCS repository cannot be null");
        this.versionControlSpec = versionControlSpec;
    }

    @Override
    public <T extends VersionControlSpec> void from(Class<T> type, Action<? super T> configureAction) {
        T spec = this.specFactory.create(type);
        configureAction.execute(spec);
        this.versionControlSpec = spec;
    }

    @Override
    public VersionControlSpec getRepository() {
        return this.versionControlSpec;
    }

    @Override
    public boolean hasRepository() {
        return this.versionControlSpec != null;
    }
}

