/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.fixtures.sources;

import dev.gradleplugins.fixtures.sources.NativeSourceElement;
import dev.gradleplugins.fixtures.sources.SourceElement;
import dev.gradleplugins.fixtures.sources.SourceFile;
import dev.gradleplugins.fixtures.sources.SourceKind;
import java.util.ArrayList;
import java.util.stream.Collectors;

public abstract class NativeLibraryElement
extends NativeSourceElement {
    public abstract SourceElement getPublicHeaders();

    public SourceElement getPrivateHeaders() {
        return NativeLibraryElement.empty();
    }

    @Override
    public SourceElement getHeaders() {
        return NativeLibraryElement.ofElements(this.getPublicHeaders(), this.getPrivateHeaders());
    }

    public static SourceElement ofPublicHeaders(SourceElement element) {
        return NativeLibraryElement.ofFiles(element.getFiles().stream().filter(it -> it.getKind().equals(SourceKind.HEADER) && it.getPath().equals("public")).collect(Collectors.toList()));
    }

    public static SourceElement ofPrivateHeaders(SourceElement element) {
        return NativeLibraryElement.ofFiles(element.getFiles().stream().filter(it -> it.getKind().equals(SourceKind.HEADER) && !it.getPath().equals("public")).collect(Collectors.toList()));
    }

    public NativeLibraryElement asLib() {
        final NativeLibraryElement delegate = this;
        return new NativeLibraryElement(){

            @Override
            public SourceElement getPublicHeaders() {
                ArrayList<SourceFile> headers = new ArrayList<SourceFile>();
                for (SourceFile sourceFile : delegate.getPublicHeaders().getFiles()) {
                    headers.add(1.sourceFile("public", sourceFile.getName(), sourceFile.getContent()));
                }
                return SourceElement.ofFiles(headers);
            }

            @Override
            public SourceElement getPrivateHeaders() {
                return delegate.getPrivateHeaders();
            }

            @Override
            public SourceElement getSources() {
                return delegate.getSources();
            }
        };
    }
}

