/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.fixtures.sources;

import dev.gradleplugins.fixtures.sources.SourceKind;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;

public final class SourceFile {
    private final String path;
    private final String name;
    private final String content;

    public File writeToDirectory(File base) {
        return this.writeToDirectory(base, this.name);
    }

    private File writeToDirectory(File base, String name) {
        File file = new File(base, String.join((CharSequence)File.separator, this.path, name));
        this.writeToFile(file);
        return file;
    }

    public void writeToFile(File file) {
        try {
            FileUtils.touch((File)file);
            FileUtils.write((File)file, (CharSequence)this.content, (Charset)Charset.defaultCharset());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(String.format("Unable to create source file at '%s'.", file.getAbsolutePath()), ex);
        }
    }

    public String withPath(String basePath) {
        return String.join((CharSequence)"/", basePath, this.path, this.name);
    }

    public String toString() {
        return "SourceFile{path='" + this.path + '\'' + ", name='" + this.name + '\'' + ", content='" + SourceFile.firstContentLine(this.content) + '\'' + '}';
    }

    private static String firstContentLine(String content) {
        String[] tokens = content.split("\n", -1);
        return Arrays.stream(tokens).map(String::trim).filter(line -> !line.isEmpty()).findFirst().map(it -> it + "...").orElse("");
    }

    public SourceKind getKind() {
        return SourceKind.valueOf(this.name);
    }

    public SourceFile(String path, String name, String content) {
        this.path = path;
        this.name = name;
        this.content = content;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceFile)) {
            return false;
        }
        SourceFile other = (SourceFile)o;
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }
}

