/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.integtests.fixtures;

import dev.gradleplugins.integtests.fixtures.AbstractMultiTestRunner;
import dev.gradleplugins.integtests.fixtures.AbstractMultiVersionSpecRunner;
import dev.gradleplugins.integtests.fixtures.GradleDistributionTool;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleDistribution;
import dev.gradleplugins.test.fixtures.versions.ReleasedVersionDistributions;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.os.OperatingSystem;

public abstract class AbstractGradleCompatibilityTestRunner
extends AbstractMultiVersionSpecRunner<GradleDistributionTool> {
    final ReleasedVersionDistributions releasedVersions = new ReleasedVersionDistributions();

    public AbstractGradleCompatibilityTestRunner(Class<?> target, Set<AbstractMultiVersionSpecRunner.CoverageContext> coverageContexts) {
        super(target, coverageContexts);
    }

    @Override
    protected Collection<GradleDistributionTool> getAllVersions() {
        List<GradleDistribution> allSupportedVersions = this.chooseVersionsToTest(this.releasedVersions);
        List sortedDistributions = allSupportedVersions.stream().sorted(Comparator.comparing(GradleDistribution::getVersion)).collect(Collectors.toList());
        return sortedDistributions.stream().map(this::versionedToolFrom).collect(Collectors.toList());
    }

    @Override
    protected boolean isAvailable(GradleDistributionTool version) {
        return true;
    }

    @Override
    protected Collection<AbstractMultiTestRunner.Execution> createExecutionsFor(GradleDistributionTool versionedTool) {
        if (versionedTool.getIgnored() != null) {
            return Collections.singleton(new IgnoredVersion(versionedTool.getDistribution(), versionedTool.getIgnored()));
        }
        return this.createDistributionExecutionsFor(versionedTool);
    }

    protected GradleDistributionTool versionedToolFrom(GradleDistribution distribution) {
        if (!distribution.worksWith(Jvm.current())) {
            return new GradleDistributionTool(distribution, "does not work with current JVM");
        }
        if (!distribution.worksWith(OperatingSystem.current())) {
            return new GradleDistributionTool(distribution, "does not work with current OS");
        }
        return new GradleDistributionTool(distribution);
    }

    protected List<GradleDistribution> chooseVersionsToTest(ReleasedVersionDistributions releasedVersions) {
        return Collections.emptyList();
    }

    protected Collection<AbstractMultiTestRunner.Execution> createDistributionExecutionsFor(GradleDistributionTool versionedTool) {
        return Collections.emptyList();
    }

    private static class IgnoredVersion
    extends AbstractMultiTestRunner.Execution {
        private final GradleDistribution distribution;
        private final String why;

        private IgnoredVersion(GradleDistribution distribution, String why) {
            this.distribution = distribution;
            this.why = why;
        }

        @Override
        protected boolean isTestEnabled(AbstractMultiTestRunner.TestDetails testDetails) {
            return false;
        }

        @Override
        protected String getDisplayName() {
            return String.format("%s %s", this.distribution.getVersion(), this.why);
        }
    }
}

