/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.integtests.fixtures;

import dev.gradleplugins.integtests.fixtures.AbstractContextualMultiVersionSpecRunner;
import dev.gradleplugins.integtests.fixtures.AbstractMultiTestRunner;
import dev.gradleplugins.integtests.fixtures.DefaultVersionedTool;
import dev.gradleplugins.integtests.fixtures.TargetCoverage;
import dev.gradleplugins.integtests.fixtures.TargetVersions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class MultiVersionSpecRunner
extends AbstractContextualMultiVersionSpecRunner<DefaultVersionedTool> {
    private final Class<?> target;
    private final TargetVersions versions;
    private final TargetCoverage coverage;

    public MultiVersionSpecRunner(Class<?> target) {
        super(target);
        this.target = target;
        this.versions = target.getAnnotation(TargetVersions.class);
        this.coverage = target.getAnnotation(TargetCoverage.class);
    }

    @Override
    protected Collection<DefaultVersionedTool> getAllVersions() {
        if (this.versions != null) {
            return MultiVersionSpecRunner.versionsFrom(Arrays.asList(this.versions.value()));
        }
        if (this.coverage != null) {
            try {
                return MultiVersionSpecRunner.versionsFrom((List)this.coverage.value().getConstructor(Class.class, Class.class).newInstance(this.target, this.target).call());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException(String.format("Target class '%s' is not annotated with @%s nor with @%s.", this.target.getSimpleName(), TargetVersions.class.getSimpleName(), TargetCoverage.class.getSimpleName()));
    }

    @Override
    protected boolean isAvailable(DefaultVersionedTool version) {
        return true;
    }

    @Override
    protected Collection<AbstractMultiTestRunner.Execution> createExecutionsFor(DefaultVersionedTool versionedTool) {
        return Collections.singleton(new VersionExecution(versionedTool.getVersion()));
    }

    static List<DefaultVersionedTool> versionsFrom(List<Object> versions) {
        return versions.stream().map(DefaultVersionedTool::new).collect(Collectors.toList());
    }

    private static class VersionExecution
    extends AbstractMultiTestRunner.Execution {
        private final Object version;

        VersionExecution(Object version) {
            this.version = version;
        }

        @Override
        protected String getDisplayName() {
            return this.version.toString();
        }

        @Override
        protected void before() {
            try {
                Method m = this.target.getMethod("setVersion", Object.class);
                m.invoke((Object)this.target, this.version);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Please define a setVersion(Object) static setter. You can also just use `static def version`.");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Make sure the setVersion(Object) static setter is public.");
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Error while invoking setVersion(Object) on " + this.target.getSimpleName());
            }
        }
    }
}

