/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.spock.lang;

import dev.gradleplugins.spock.lang.FileUtils;
import dev.gradleplugins.spock.lang.TestDirectoryProvider;
import dev.gradleplugins.test.fixtures.util.RetryUtil;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SystemUtils;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

abstract class AbstractTestDirectoryProvider
implements TestRule,
TestDirectoryProvider {
    protected final File root;
    protected final String className;
    private static final Random RANDOM = new Random();
    private static final int ALL_DIGITS_AND_LETTERS_RADIX = 36;
    private static final int MAX_RANDOM_PART_VALUE = Integer.valueOf("zzzzz", 36);
    private static final Pattern WINDOWS_RESERVED_NAMES = Pattern.compile("(con)|(prn)|(aux)|(nul)|(com\\d)|(lpt\\d)", 2);
    private File dir;
    private String prefix;
    private boolean cleanup = true;

    public AbstractTestDirectoryProvider(File root, Class<?> testClass) {
        this.root = root;
        String safeClassName = testClass.getSimpleName();
        if (SystemUtils.IS_OS_WINDOWS && safeClassName.length() > 20) {
            safeClassName = safeClassName.substring(0, 10) + "..." + safeClassName.substring(safeClassName.length() - 9);
        }
        this.className = safeClassName;
    }

    @Override
    public void suppressCleanup() {
        this.cleanup = false;
    }

    public boolean isCleanup() {
        return this.cleanup;
    }

    public void cleanup() {
        if (this.cleanup && this.dir != null && this.dir.exists()) {
            try {
                RetryUtil.retry((int)100, (Duration)Duration.ofMillis(100L), () -> {
                    try {
                        FileUtils.forceDeleteDirectory(this.dir);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Statement apply(Statement base, Description description) {
        this.init(description.getMethodName());
        return new TestDirectoryCleaningStatement(base, description);
    }

    protected void init(String methodName) {
        if (methodName == null) {
            methodName = this.getClass().getSimpleName();
        }
        if (this.prefix == null) {
            String safeMethodName = methodName.replaceAll("[^\\w]", "_");
            if (safeMethodName.length() > 30) {
                safeMethodName = safeMethodName.substring(0, 19) + "..." + safeMethodName.substring(safeMethodName.length() - 9);
            }
            this.prefix = String.format("%s/%s", this.className, safeMethodName);
        }
    }

    @Override
    public File getTestDirectory() {
        if (this.dir == null) {
            this.dir = this.createUniqueTestDirectory();
        }
        return this.dir;
    }

    private File createUniqueTestDirectory() {
        File dir;
        while (true) {
            String randomPrefix;
            if (WINDOWS_RESERVED_NAMES.matcher(randomPrefix = Integer.toString(RANDOM.nextInt(MAX_RANDOM_PART_VALUE), 36)).matches()) {
                continue;
            }
            dir = new File(this.root, String.format("%s/%s", this.getPrefix(), randomPrefix));
            if (dir.mkdirs()) break;
        }
        return dir;
    }

    private String getPrefix() {
        if (this.prefix == null) {
            this.prefix = this.className;
        }
        return this.prefix;
    }

    public File file(String ... path) {
        return FileUtils.file(this.getTestDirectory(), path);
    }

    public File createFile(String ... path) {
        return FileUtils.createFile(this.file(path));
    }

    public File createDirectory(String ... path) {
        return FileUtils.createDirectory(this.file(path));
    }

    private class TestDirectoryCleaningStatement
    extends Statement {
        private final Statement base;
        private final Description description;

        TestDirectoryCleaningStatement(Statement base, Description description) {
            this.base = base;
            this.description = description;
        }

        public void evaluate() throws Throwable {
            this.base.evaluate();
            try {
                AbstractTestDirectoryProvider.this.cleanup();
            }
            catch (Exception e) {
                throw new RuntimeException(this.cleanupErrorMessage(), e);
            }
        }

        private String cleanupErrorMessage() {
            return "Couldn't delete test dir for `" + this.displayName() + "` (test is holding files open). In order to find out which files are held open you may find http://file-leak-detector.kohsuke.org/ useful.";
        }

        private String displayName() {
            return this.description.getDisplayName();
        }
    }
}

