/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.daemon;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.context.DefaultDaemonContext;

public class DaemonContextParser {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DaemonContext parseFromFile(File file) {
        try (FileReader in = new FileReader(file);
             BufferedReader reader = new BufferedReader(in);){
            String line = reader.readLine();
            while (line != null) {
                DaemonContext context = DaemonContextParser.parseFrom(line);
                if (context != null) {
                    DaemonContext daemonContext = context;
                    return daemonContext;
                }
                line = reader.readLine();
            }
            throw new IllegalStateException("unable to parse DefaultDaemonContext from source: [" + file.getAbsolutePath() + "].");
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to parse DefaultDaemonContext from source: [" + file.getAbsolutePath() + "].", e);
        }
    }

    public static DaemonContext parseFromString(String source) {
        DaemonContext context = DaemonContextParser.parseFrom(source);
        if (context == null) {
            throw new IllegalStateException("unable to parse DefaultDaemonContext from source: [" + source + "].");
        }
        return context;
    }

    private static DaemonContext parseFrom(String source) {
        Pattern pattern = Pattern.compile("^.*DefaultDaemonContext\\[(uid=[^\\n,]+)?,?javaHome=([^\\n]+),daemonRegistryDir=([^\\n]+),pid=([^\\n]+),idleTimeout=(.+?)(,priority=[^\\n]+)?,daemonOpts=([^\\n]+)].*", 40);
        Matcher matcher = pattern.matcher(source);
        if (matcher.matches()) {
            String uid = matcher.group(1) == null ? null : matcher.group(1).substring("uid=".length());
            String javaHome = matcher.group(2);
            String daemonRegistryDir = matcher.group(3);
            String pidStr = matcher.group(4);
            Long pid = pidStr.equals("null") ? null : Long.valueOf(Long.parseLong(pidStr));
            Integer idleTimeout = Integer.decode(matcher.group(5));
            DaemonParameters.Priority priority = matcher.group(6) == null ? DaemonParameters.Priority.NORMAL : DaemonParameters.Priority.valueOf((String)matcher.group(6).substring(",priority=".length()));
            ArrayList jvmOpts = Lists.newArrayList((Iterable)Splitter.on((char)',').split((CharSequence)matcher.group(7)));
            return new DefaultDaemonContext(uid, new File(javaHome), new File(daemonRegistryDir), pid, idleTimeout, (List)jvmOpts, priority);
        }
        return null;
    }
}

