/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.daemon;

import dev.gradleplugins.test.fixtures.gradle.NativeServicesTestFixture;
import dev.gradleplugins.test.fixtures.gradle.daemon.DaemonStateProbe;
import java.io.File;
import java.util.Optional;
import org.gradle.internal.file.Stat;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.registry.DaemonDir;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.server.api.DaemonStateControl;

public class DaemonRegistryStateProbe
implements DaemonStateProbe {
    private final DaemonRegistry registry;
    private final DaemonContext context;

    public DaemonRegistryStateProbe(DaemonRegistry registry, DaemonContext context) {
        this.context = context;
        this.registry = registry;
    }

    public void resetToken() {
        DaemonInfo daemonInfo = this.registry.getAll().stream().filter(it -> it.getContext().getPid().equals(this.context.getPid())).findFirst().orElse(null);
        this.registry.remove(daemonInfo.getAddress());
        this.registry.store(new DaemonInfo(daemonInfo.getAddress(), daemonInfo.getContext(), "password".getBytes(), daemonInfo.getState()));
    }

    public void assertRegistryNotWorldReadable() {
        File registryFile = new DaemonDir(this.context.getDaemonRegistryDir()).getRegistry();
        if (OperatingSystem.current().isLinux() || OperatingSystem.current().isMacOsX()) {
            Stat stat = (Stat)NativeServicesTestFixture.getInstance().get(Stat.class);
            assert (stat.getUnixMode(registryFile) == 384);
            assert (stat.getUnixMode(registryFile.getParentFile()) == 448);
        }
    }

    @Override
    public DaemonStateControl.State getCurrentState() {
        Optional<DaemonInfo> daemonInfo = this.registry.getAll().stream().filter(it -> it.getContext().getPid().equals(this.context.getPid())).findFirst();
        if (!daemonInfo.isPresent()) {
            return DaemonStateControl.State.Stopped;
        }
        return daemonInfo.get().getState();
    }
}

