/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.daemon;

import dev.gradleplugins.test.fixtures.gradle.daemon.AbstractDaemonFixture;
import dev.gradleplugins.test.fixtures.gradle.daemon.DaemonLogFileStateProbe;
import java.io.File;
import org.gradle.internal.time.CountdownTimer;
import org.gradle.internal.time.Time;
import org.gradle.launcher.daemon.server.api.DaemonStateControl;
import org.gradle.util.GradleVersion;

public class LegacyDaemon
extends AbstractDaemonFixture {
    private final DaemonLogFileStateProbe logFileProbe;

    public LegacyDaemon(File daemonLog, String version) {
        super(daemonLog);
        this.logFileProbe = 0 >= GradleVersion.version((String)version).getBaseVersion().compareTo(GradleVersion.version((String)"2.2")) ? new DaemonLogFileStateProbe(daemonLog, this.context) : new DaemonLogFileStateProbe(daemonLog, this.context, "Daemon is busy, sleeping until state changes", "Daemon is idle, sleeping until state change");
    }

    @Override
    protected void waitForState(DaemonStateControl.State state) throws InterruptedException {
        CountdownTimer timer = Time.startCountdownTimer((long)20000L);
        DaemonStateControl.State lastLogState = this.logFileProbe.getCurrentState();
        while (!timer.hasExpired() && lastLogState != state) {
            Thread.sleep(200L);
            lastLogState = this.logFileProbe.getCurrentState();
        }
        if (lastLogState == state) {
            return;
        }
        throw new AssertionError((Object)String.format("Timeout waiting for daemon with pid %d to reach state %s.%nCurrent state is %s.", this.context.getPid(), state, lastLogState));
    }

    @Override
    protected void assertHasState(DaemonStateControl.State state) {
        assert (this.logFileProbe.getCurrentState() == state);
    }

    @Override
    public String getLog() {
        return this.logFileProbe.getLog();
    }

    @Override
    public File getLogFile() {
        return this.logFileProbe.getLogFile();
    }

    @Override
    public void changeTokenVisibleToClient() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void assertRegistryNotWorldReadable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPort() {
        throw new UnsupportedOperationException();
    }
}

