/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer;

import dev.gradleplugins.test.fixtures.file.TestFile;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleDistribution;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.CurrentGradleDistribution;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.ReleasedGradleDistribution;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.WrapperGradleDistribution;
import java.io.File;
import java.nio.file.LinkOption;
import javax.annotation.Nullable;

public class GradleDistributionFactory {
    private static final TestFile TEST_DIR = TestFile.of(new File("."), new LinkOption[0]);

    public static GradleDistribution distribution(String version) {
        TestFile previousVersionDir = GradleDistributionFactory.getGradleUserHomeDir().getParentFile().file("previousVersion");
        return new ReleasedGradleDistribution(version, previousVersionDir.file(version));
    }

    public static GradleDistribution wrapper(File rootProjectDirectory) {
        return new WrapperGradleDistribution(rootProjectDirectory);
    }

    public static GradleDistribution current() {
        return new CurrentGradleDistribution();
    }

    private static TestFile getGradleUserHomeDir() {
        return GradleDistributionFactory.file("integTest.gradleUserHomeDir", "intTestHomeDir").file("worker-1");
    }

    protected static TestFile file(String propertyName, String defaultPath) {
        TestFile testFile = GradleDistributionFactory.optionalFile(propertyName);
        if (testFile != null) {
            return testFile;
        }
        if (defaultPath == null) {
            throw new RuntimeException("You must set the '" + propertyName + "' property to run the integration tests.");
        }
        return GradleDistributionFactory.testFile(defaultPath);
    }

    @Nullable
    private static TestFile optionalFile(String propertyName) {
        String path = System.getProperty(propertyName);
        return path != null ? new TestFile(new File(path.replace(".idea/modules/", "")), new Object[0]) : null;
    }

    private static TestFile testFile(String path) {
        File file = new File(path);
        return file.isAbsolute() ? new TestFile(file, new Object[0]) : new TestFile((File)TEST_DIR.file(path).getAbsoluteFile(), new Object[0]);
    }
}

