/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import dev.gradleplugins.test.fixtures.file.TestFile;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.DefaultGradleDistribution;
import java.io.File;
import java.net.URL;
import java.nio.file.LinkOption;
import org.gradle.util.GradleVersion;

public abstract class DownloadableGradleDistribution
extends DefaultGradleDistribution {
    private static final LoadingCache<Key, File> CACHE = DownloadableGradleDistribution.createCache();
    protected File versionDirectory;

    private static LoadingCache<Key, File> createCache() {
        return CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<Key, File>(){

            public File load(Key key) {
                System.out.println("downloading " + key.url.toString());
                key.getBinDistribution().copyFrom(key.url);
                key.getBinDistribution().usingNativeTools().unzipTo(key.versionDirectory);
                return key.getBinDistribution();
            }
        });
    }

    public DownloadableGradleDistribution(String version, File versionDirectory) {
        super(GradleVersion.version((String)version), TestFile.of(new File(versionDirectory, String.format("gradle-%s", version)), new LinkOption[0]), TestFile.of(new File(versionDirectory, String.format("gradle-%s-bin.zip", version)), new LinkOption[0]));
        this.versionDirectory = versionDirectory;
    }

    @Override
    public TestFile getBinDistribution() {
        this.download();
        return super.getBinDistribution();
    }

    @Override
    public TestFile getGradleHomeDirectory() {
        this.download();
        return super.getGradleHomeDirectory();
    }

    private void download() {
        CACHE.getUnchecked((Object)new Key(this.getDownloadURL(), super.getBinDistribution(), this.versionDirectory));
        super.getBinDistribution().assertIsFile();
        super.getGradleHomeDirectory().assertIsDirectory();
    }

    protected abstract URL getDownloadURL();

    private static final class Key {
        private final URL url;
        private final TestFile binDistribution;
        private final File versionDirectory;

        public Key(URL url, TestFile binDistribution, File versionDirectory) {
            this.url = url;
            this.binDistribution = binDistribution;
            this.versionDirectory = versionDirectory;
        }

        public URL getUrl() {
            return this.url;
        }

        public TestFile getBinDistribution() {
            return this.binDistribution;
        }

        public File getVersionDirectory() {
            return this.versionDirectory;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            URL this$url = this.getUrl();
            URL other$url = other.getUrl();
            if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
                return false;
            }
            TestFile this$binDistribution = this.getBinDistribution();
            TestFile other$binDistribution = other.getBinDistribution();
            if (this$binDistribution == null ? other$binDistribution != null : !((Object)this$binDistribution).equals(other$binDistribution)) {
                return false;
            }
            File this$versionDirectory = this.getVersionDirectory();
            File other$versionDirectory = other.getVersionDirectory();
            return !(this$versionDirectory == null ? other$versionDirectory != null : !((Object)this$versionDirectory).equals(other$versionDirectory));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            URL $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
            TestFile $binDistribution = this.getBinDistribution();
            result = result * 59 + ($binDistribution == null ? 43 : ((Object)$binDistribution).hashCode());
            File $versionDirectory = this.getVersionDirectory();
            result = result * 59 + ($versionDirectory == null ? 43 : ((Object)$versionDirectory).hashCode());
            return result;
        }

        public String toString() {
            return "DownloadableGradleDistribution.Key(url=" + this.getUrl() + ", binDistribution=" + this.getBinDistribution() + ", versionDirectory=" + this.getVersionDirectory() + ")";
        }
    }
}

