/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.gradle.internal.UncheckedException;

class OutputCapturer {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final OutputStream outputStream;
    private final Charset outputEncoding;

    public OutputCapturer(OutputStream standardStream, Charset outputEncoding) {
        this.outputStream = new CloseShieldOutputStream((OutputStream)new TeeOutputStream(standardStream, (OutputStream)this.buffer));
        this.outputEncoding = outputEncoding;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public String getOutputAsString() {
        try {
            return this.buffer.toString(this.outputEncoding.name());
        }
        catch (UnsupportedEncodingException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

