/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer;

import dev.gradleplugins.test.fixtures.Pair;
import dev.gradleplugins.test.fixtures.gradle.executer.DependencyResolutionFailure;
import dev.gradleplugins.test.fixtures.gradle.executer.DetailedExecutionFailure;
import dev.gradleplugins.test.fixtures.gradle.executer.ExecutionFailure;
import dev.gradleplugins.test.fixtures.gradle.executer.LogContent;
import dev.gradleplugins.test.fixtures.gradle.executer.OutputScrapingExecutionResult;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.util.TextUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class OutputScrapingExecutionFailure
extends OutputScrapingExecutionResult
implements ExecutionFailure {
    private static final Pattern FAILURE_PATTERN = Pattern.compile("FAILURE: (.+)");
    private static final Pattern CAUSE_PATTERN = Pattern.compile("(?m)(^\\s*> )");
    private static final Pattern DESCRIPTION_PATTERN = Pattern.compile("(?ms)^\\* What went wrong:$(.+?)^\\* Try:$");
    private static final Pattern LOCATION_PATTERN = Pattern.compile("(?ms)^\\* Where:((.+?)'.+?') line: (\\d+)$");
    private static final Pattern RESOLUTION_PATTERN = Pattern.compile("(?ms)^\\* Try:$(.+?)^\\* Exception is:$");
    private final String summary;
    private final List<String> descriptions = new ArrayList<String>();
    private final List<String> lineNumbers = new ArrayList<String>();
    private final List<String> fileNames = new ArrayList<String>();
    private final String resolution;
    private final List<String> causes = new ArrayList<String>();
    private final LogContent mainContent;

    static boolean hasFailure(String error) {
        return FAILURE_PATTERN.matcher(error).find();
    }

    public static OutputScrapingExecutionFailure from(String output, String error) {
        return new OutputScrapingExecutionFailure(output, error, true);
    }

    protected OutputScrapingExecutionFailure(String output, String error, boolean includeBuildSrc) {
        super(LogContent.of(output), LogContent.of(error), includeBuildSrc);
        LogContent withoutDebug = LogContent.of(output).ansiCharsToPlainText().removeDebugPrefix();
        Pair<LogContent, LogContent> match = withoutDebug.splitOnFirstMatchingLine(FAILURE_PATTERN);
        if (match == null) {
            match = LogContent.of(error).ansiCharsToPlainText().removeDebugPrefix().splitOnFirstMatchingLine(FAILURE_PATTERN);
            match = match != null ? Pair.of(withoutDebug, match.getRight()) : Pair.of(withoutDebug, LogContent.empty());
        } else if (match.getRight().countMatches(FAILURE_PATTERN) != 1) {
            throw new IllegalArgumentException("Found multiple failure sections in log output: " + output);
        }
        LogContent failureContent = match.getRight();
        this.mainContent = (LogContent)match.getLeft();
        String failureText = failureContent.withNormalizedEol();
        Matcher matcher = FAILURE_PATTERN.matcher(failureText);
        this.summary = matcher.lookingAt() ? matcher.group(1) : "";
        matcher = LOCATION_PATTERN.matcher(failureText);
        while (matcher.find()) {
            this.fileNames.add(matcher.group(1).trim());
            this.lineNumbers.add(matcher.group(3));
        }
        matcher = DESCRIPTION_PATTERN.matcher(failureText);
        while (matcher.find()) {
            String problemStr = matcher.group(1);
            Problem problem = this.extract(problemStr);
            this.descriptions.add(problem.description);
            this.causes.addAll(problem.causes);
        }
        matcher = RESOLUTION_PATTERN.matcher(failureText);
        this.resolution = !matcher.find() ? "" : matcher.group(1).trim();
    }

    @Override
    public ExecutionFailure getIgnoreBuildSrc() {
        return new OutputScrapingExecutionFailure(this.getOutput(), this.getError(), false);
    }

    @Override
    public LogContent getMainContent() {
        return this.mainContent;
    }

    private Problem extract(String problem) {
        String description;
        Matcher matcher = CAUSE_PATTERN.matcher(problem);
        ArrayList<String> causes = new ArrayList<String>();
        if (!matcher.find()) {
            description = TextUtil.normaliseLineSeparators((String)problem.trim());
        } else {
            String cause;
            String prefixPattern;
            int pos;
            description = TextUtil.normaliseLineSeparators((String)problem.substring(0, matcher.start()).trim());
            while (true) {
                pos = matcher.end();
                int prefix = matcher.group(1).length();
                prefixPattern = this.toPrefixPattern(prefix);
                if (!matcher.find(pos)) break;
                cause = TextUtil.normaliseLineSeparators((String)problem.substring(pos, matcher.start()).trim().replaceAll(prefixPattern, ""));
                causes.add(cause);
            }
            cause = TextUtil.normaliseLineSeparators((String)problem.substring(pos).trim().replaceAll(prefixPattern, ""));
            causes.add(cause);
        }
        return new Problem(description, causes);
    }

    private String toPrefixPattern(int prefix) {
        StringBuilder builder = new StringBuilder("(?m)^");
        for (int i = 0; i < prefix; ++i) {
            builder.append(' ');
        }
        return builder.toString();
    }

    public ExecutionFailure assertHasLineNumber(int lineNumber) {
        Assert.assertThat(this.lineNumbers, (org.hamcrest.Matcher)CoreMatchers.hasItem((org.hamcrest.Matcher)CoreMatchers.equalTo((Object)String.valueOf(lineNumber))));
        return this;
    }

    public ExecutionFailure assertHasFileName(String filename) {
        Assert.assertThat(this.fileNames, (org.hamcrest.Matcher)CoreMatchers.hasItem((org.hamcrest.Matcher)CoreMatchers.equalTo((Object)filename)));
        return this;
    }

    public ExecutionFailure assertHasFailures(int count) {
        Assert.assertThat((Object)this.descriptions.size(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)count));
        if (count == 1) {
            Assert.assertThat((Object)this.summary, (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"Build failed with an exception."));
        } else {
            Assert.assertThat((Object)this.summary, (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)String.format("Build completed with %s failures.", count)));
        }
        return this;
    }

    @Override
    public ExecutionFailure assertHasCause(String description) {
        this.assertThatCause((org.hamcrest.Matcher<? super String>)CoreMatchers.startsWith((String)description));
        return this;
    }

    @Override
    public ExecutionFailure assertThatCause(org.hamcrest.Matcher<? super String> matcher) {
        for (String cause : this.causes) {
            if (!matcher.matches((Object)cause)) continue;
            return this;
        }
        this.failureOnUnexpectedOutput(String.format("No matching cause found in %s", this.causes));
        return this;
    }

    public ExecutionFailure assertHasResolution(String resolution) {
        Assert.assertThat((Object)this.resolution, (org.hamcrest.Matcher)CoreMatchers.containsString((String)resolution));
        return this;
    }

    public ExecutionFailure assertHasNoCause(String description) {
        org.hamcrest.Matcher matcher = CoreMatchers.containsString((String)description);
        for (String cause : this.causes) {
            if (!matcher.matches((Object)cause)) continue;
            this.failureOnUnexpectedOutput(String.format("Expected no failure with description '%s', found: %s", description, cause));
        }
        return this;
    }

    public ExecutionFailure assertHasNoCause() {
        Assert.assertThat(this.causes, (org.hamcrest.Matcher)Matchers.empty());
        return this;
    }

    @Override
    public ExecutionFailure assertHasDescription(String context) {
        this.assertThatDescription((org.hamcrest.Matcher<? super String>)CoreMatchers.startsWith((String)context));
        return this;
    }

    public ExecutionFailure assertThatDescription(org.hamcrest.Matcher<? super String> matcher) {
        for (String description : this.descriptions) {
            if (!matcher.matches((Object)description)) continue;
            return this;
        }
        this.failureOnUnexpectedOutput(String.format("No matching failure description found in %s", this.descriptions));
        return this;
    }

    public ExecutionFailure assertTestsFailed() {
        new DetailedExecutionFailure(this).assertTestsFailed();
        return this;
    }

    public DependencyResolutionFailure assertResolutionFailure(String configurationPath) {
        return new DependencyResolutionFailure(this, configurationPath);
    }

    private static class Problem {
        final String description;
        final List<String> causes;

        private Problem(String description, List<String> causes) {
            this.description = description;
            this.causes = causes;
        }
    }
}

