/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.logging;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.specs.Spec;
import org.gradle.util.CollectionUtils;

public class GroupedTransformationFixture {
    private final String initialSubjectType;
    private final String subject;
    private final String transformer;
    private final List<String> outputs = new ArrayList<String>(1);

    public GroupedTransformationFixture(String initialSubjectType, String subject, String transformer) {
        this.initialSubjectType = initialSubjectType;
        this.subject = subject;
        this.transformer = transformer;
    }

    public void addOutput(String transformationOutput) {
        this.outputs.add(transformationOutput);
    }

    public String getInitialSubjectType() {
        return this.initialSubjectType;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getTransformer() {
        return this.transformer;
    }

    public String getOutput() {
        List nonEmptyOutputs = CollectionUtils.filter(this.outputs, (Spec)new Spec<String>(){

            public boolean isSatisfiedBy(String string) {
                return !string.equals("");
            }
        });
        return CollectionUtils.join((String)"\n", (Iterable)nonEmptyOutputs);
    }

    public String toString() {
        return "GroupedTransformationFixture{initialSubjectType='" + this.initialSubjectType + '\'' + ", subject='" + this.subject + '\'' + ", transformer='" + this.transformer + '\'' + '}';
    }
}

