/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer;

import dev.gradleplugins.test.fixtures.gradle.executer.SequentialOutputMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;

public class AnyOrderOutputMatcher
extends SequentialOutputMatcher {
    @Override
    protected void assertOutputLinesMatch(List<String> expectedLines, List<String> actualLines, boolean ignoreExtraLines, String actual) {
        ArrayList<String> unmatchedLines = new ArrayList<String>(actualLines);
        expectedLines.removeIf(String::isEmpty);
        unmatchedLines.removeIf(String::isEmpty);
        expectedLines.forEach(expectedLine -> {
            List matchedLine = unmatchedLines.stream().filter(actualLine -> this.compare((String)expectedLine, (String)actualLine)).collect(Collectors.toList());
            if (!matchedLine.isEmpty()) {
                unmatchedLines.removeAll(matchedLine);
            } else {
                Assert.fail((String)String.format("Line missing from output.%n%s%n---%nActual output:%n%s%n---", expectedLine, actual));
            }
        });
        if (!ignoreExtraLines && !unmatchedLines.isEmpty()) {
            String unmatched = String.join((CharSequence)System.lineSeparator(), unmatchedLines);
            Assert.fail((String)String.format("Extra lines in output.%n%s%n---%nActual output:%n%s%n---", unmatched, actual));
        }
    }
}

