/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer;

import dev.gradleplugins.test.fixtures.gradle.executer.ExecutionFailure;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class DependencyResolutionFailure {
    private final ExecutionFailure failure;

    public DependencyResolutionFailure(ExecutionFailure failure, String configuration) {
        this.failure = failure;
        this.assertFailedConfiguration(configuration);
    }

    public DependencyResolutionFailure assertFailedConfiguration(String configuration) {
        this.failure.assertThatCause((Matcher<? super String>)Matchers.matchesPattern((String)("Could not resolve all (dependencies|artifacts|files) for configuration '" + Pattern.quote(configuration) + "'.")));
        return this;
    }

    public DependencyResolutionFailure assertFailedDependencyRequiredBy(String dependency) {
        this.failure.assertThatCause((Matcher<? super String>)Matchers.matchesPattern((String)("(?ms).*Required by:\\s+" + dependency + ".*")));
        return this;
    }

    public DependencyResolutionFailure assertHasCause(String cause) {
        this.failure.assertHasCause(cause);
        return this;
    }

    public DependencyResolutionFailure assertThatCause(Matcher<String> matcher) {
        this.failure.assertThatCause(matcher);
        return this;
    }
}

