/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer;

import dev.gradleplugins.test.fixtures.gradle.executer.TaskOrderSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.util.GUtil;

public class TaskOrderSpecs {
    public static TaskOrderSpec any(Object[] constraints) {
        return new AnyOrderSpec(Arrays.asList(constraints));
    }

    public static TaskOrderSpec exact(Object[] constraints) {
        List flattenedConstraints = (List)GUtil.flatten((Object[])constraints, new ArrayList());
        return new ExactOrderSpec(flattenedConstraints);
    }

    private static class ExactOrderSpec
    extends RecursiveOrderSpec {
        public ExactOrderSpec(List<Object> constraints) {
            super(constraints);
        }

        @Override
        public int assertMatches(int lastIndex, List<String> executedTaskPaths) {
            for (Object constraint : this.constraints) {
                lastIndex = this.checkConstraint(constraint, lastIndex, executedTaskPaths);
            }
            return lastIndex;
        }

        @Override
        String getDisplayName() {
            return "exact";
        }
    }

    private static class AnyOrderSpec
    extends RecursiveOrderSpec {
        public AnyOrderSpec(List<Object> constraints) {
            super(constraints);
        }

        @Override
        public int assertMatches(int lastIndex, List<String> executedTaskPaths) {
            int highestIndex = lastIndex;
            for (Object constraint : this.constraints) {
                int index = this.checkConstraint(constraint, lastIndex, executedTaskPaths);
                highestIndex = Math.max(index, highestIndex);
            }
            return highestIndex;
        }

        @Override
        String getDisplayName() {
            return "any";
        }
    }

    private static abstract class RecursiveOrderSpec
    implements TaskOrderSpec {
        protected final List<Object> constraints;

        public RecursiveOrderSpec(List<Object> constraints) {
            this.constraints = constraints;
        }

        protected int checkConstraint(Object constraint, int lastIndex, List<String> executedTaskPaths) {
            int index;
            if (constraint instanceof String) {
                index = executedTaskPaths.indexOf(constraint);
            } else if (constraint instanceof TaskOrderSpec) {
                index = ((TaskOrderSpec)constraint).assertMatches(lastIndex, executedTaskPaths);
            } else {
                throw new IllegalArgumentException();
            }
            assert (index > lastIndex) : String.format("%s does not occur in expected order (expected: %s, actual %s)", constraint, this.toString(), executedTaskPaths);
            return index;
        }

        @Override
        public Set<String> getTasks() {
            HashSet<String> tasks = new HashSet<String>();
            for (Object constraint : this.constraints) {
                if (constraint instanceof String) {
                    tasks.add((String)constraint);
                    continue;
                }
                if (constraint instanceof TaskOrderSpec) {
                    tasks.addAll(((TaskOrderSpec)constraint).getTasks());
                    continue;
                }
                throw new IllegalArgumentException();
            }
            return tasks;
        }

        abstract String getDisplayName();

        public String toString() {
            return String.format("%s(%s)", this.getDisplayName(), this.constraints);
        }
    }
}

