/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.logging;

import dev.gradleplugins.test.fixtures.gradle.executer.LogContent;
import dev.gradleplugins.test.fixtures.logging.GroupedTaskFixture;
import dev.gradleplugins.test.fixtures.logging.GroupedTransformationFixture;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class GroupedOutputFixture {
    private static final String TASK_HEADER = "> Task (:[\\w:]*) ?(FAILED|FROM-CACHE|UP-TO-DATE|SKIPPED|NO-SOURCE)?\\n";
    private static final String TRANSFORMATION_HEADER = "> Transform (artifact|file) ([^\\n]+) with ([^\\n]+)\\n";
    private static final String EMBEDDED_BUILD_START = "> :\\w* > [:\\w]+";
    private static final String BUILD_STATUS_FOOTER = "BUILD SUCCESSFUL";
    private static final String BUILD_FAILED_FOOTER = "BUILD FAILED";
    private static final String ACTIONABLE_TASKS = "[0-9]+ actionable tasks?:";
    private static final String END_OF_GROUPED_OUTPUT = "> Task (:[\\w:]*) ?(FAILED|FROM-CACHE|UP-TO-DATE|SKIPPED|NO-SOURCE)?\\n|> Transform (artifact|file) ([^\\n]+) with ([^\\n]+)\\n|BUILD SUCCESSFUL|BUILD FAILED|> :\\w* > [:\\w]+|[0-9]+ actionable tasks?:|\\z";
    private static final Pattern TASK_OUTPUT_PATTERN = GroupedOutputFixture.patternForHeader("> Task (:[\\w:]*) ?(FAILED|FROM-CACHE|UP-TO-DATE|SKIPPED|NO-SOURCE)?\\n");
    private static final Pattern TRANSFORMATION_OUTPUT_PATTERN = GroupedOutputFixture.patternForHeader("> Transform (artifact|file) ([^\\n]+) with ([^\\n]+)\\n");
    private final LogContent originalOutput;
    private final String strippedOutput;
    private Map<String, GroupedTaskFixture> tasks;
    private Map<String, GroupedTransformationFixture> transformations;

    private static Pattern patternForHeader(String header) {
        String pattern = "(?ms)";
        pattern = pattern + header;
        pattern = pattern + "([\\s\\S]*?(?=[^\\n]*?> Task (:[\\w:]*) ?(FAILED|FROM-CACHE|UP-TO-DATE|SKIPPED|NO-SOURCE)?\\n|> Transform (artifact|file) ([^\\n]+) with ([^\\n]+)\\n|BUILD SUCCESSFUL|BUILD FAILED|> :\\w* > [:\\w]+|[0-9]+ actionable tasks?:|\\z))";
        return Pattern.compile(pattern);
    }

    public GroupedOutputFixture(LogContent output) {
        this.originalOutput = output;
        this.strippedOutput = this.parse(output);
    }

    private String parse(LogContent output) {
        this.tasks = new HashMap<String, GroupedTaskFixture>();
        this.transformations = new HashMap<String, GroupedTransformationFixture>();
        String strippedOutput = output.ansiCharsToPlainText().withNormalizedEol();
        this.findOutputs(strippedOutput, TASK_OUTPUT_PATTERN, this::consumeTaskOutput);
        this.findOutputs(strippedOutput, TRANSFORMATION_OUTPUT_PATTERN, this::consumeTransformationOutput);
        return strippedOutput;
    }

    private void findOutputs(String strippedOutput, Pattern outputPattern, Consumer<Matcher> consumer) {
        Matcher matcher = outputPattern.matcher(strippedOutput);
        while (matcher.find()) {
            consumer.accept(matcher);
        }
    }

    public int getTaskCount() {
        return this.tasks.size();
    }

    public int getTransformationCount() {
        return this.transformations.size();
    }

    public boolean hasTask(String taskName) {
        return this.tasks.containsKey(taskName);
    }

    public GroupedTaskFixture task(String taskName) {
        boolean foundTask = this.hasTask(taskName);
        if (!foundTask) {
            throw new AssertionError((Object)String.format("The grouped output for task '%s' could not be found.%nOutput:%n%s", taskName, this.originalOutput));
        }
        return this.tasks.get(taskName);
    }

    public Set<String> subjectsFor(String transformer) {
        return this.transformations.values().stream().filter(transformation -> transformation.getTransformer().equals(transformer)).map(transformation -> transformation.getSubject()).collect(Collectors.toSet());
    }

    public String getStrippedOutput() {
        return this.strippedOutput;
    }

    public String toString() {
        return this.originalOutput.withNormalizedEol();
    }

    private void consumeTaskOutput(Matcher matcher) {
        String taskName = matcher.group(1);
        String taskOutcome = matcher.group(2);
        String taskOutput = StringUtils.strip((String)matcher.group(3), (String)"\n");
        GroupedTaskFixture task = this.tasks.get(taskName);
        if (task == null) {
            task = new GroupedTaskFixture(taskName);
            this.tasks.put(taskName, task);
        }
        task.addOutput(taskOutput);
        task.setOutcome(taskOutcome);
    }

    private void consumeTransformationOutput(Matcher matcher) {
        String initialSubjectType = matcher.group(1);
        String subject = matcher.group(2);
        String transformer = matcher.group(3);
        String transformationOutput = StringUtils.strip((String)matcher.group(4), (String)"\n");
        String key = initialSubjectType + ";" + subject + ";" + transformer;
        GroupedTransformationFixture transformation = this.transformations.get(key);
        if (transformation == null) {
            transformation = new GroupedTransformationFixture(initialSubjectType, subject, transformer);
            this.transformations.put(key, transformation);
        }
        transformation.addOutput(transformationOutput);
    }
}

