/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.logging;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.specs.Spec;
import org.gradle.util.CollectionUtils;

public class GroupedTaskFixture {
    private final String taskName;
    private String taskOutcome;
    private final List<String> outputs = new ArrayList<String>(1);

    public GroupedTaskFixture(String taskName) {
        this.taskName = taskName;
    }

    protected void addOutput(String output) {
        this.outputs.add(output);
    }

    public void setOutcome(String taskOutcome) {
        if (this.taskOutcome != null) {
            throw new AssertionError((Object)(this.taskName + " task's outcome is set twice!"));
        }
        this.taskOutcome = taskOutcome;
    }

    public String getOutcome() {
        return this.taskOutcome;
    }

    public String getName() {
        return this.taskName;
    }

    public String getOutput() {
        List nonEmptyOutputs = CollectionUtils.filter(this.outputs, (Spec)new Spec<String>(){

            public boolean isSatisfiedBy(String string) {
                return !string.equals("");
            }
        });
        return CollectionUtils.join((String)"\n", (Iterable)nonEmptyOutputs);
    }

    public GroupedTaskFixture assertOutputContains(String ... text) {
        String output = this.getOutput();
        for (String s : text) {
            assert (output.contains(s));
        }
        return this;
    }
}

