/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import dev.gradleplugins.test.fixtures.file.TestFile;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.DefaultGradleDistribution;
import java.io.File;
import java.net.URL;
import org.gradle.util.GradleVersion;

public abstract class DownloadableGradleDistribution
extends DefaultGradleDistribution {
    private static final LoadingCache<Key, File> CACHE = DownloadableGradleDistribution.createCache();
    protected TestFile versionDir;

    private static LoadingCache<Key, File> createCache() {
        return CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<Key, File>(){

            public File load(Key key) {
                System.out.println("downloading " + key.url.toString());
                key.getBinDistribution().copyFrom(key.url);
                key.getBinDistribution().usingNativeTools().unzipTo(key.versionDir);
                return key.getBinDistribution();
            }
        });
    }

    public DownloadableGradleDistribution(String version, TestFile versionDir) {
        super(GradleVersion.version((String)version), versionDir.file("gradle-$version"), versionDir.file("gradle-$version-bin.zip"));
        this.versionDir = versionDir;
    }

    @Override
    public TestFile getBinDistribution() {
        this.download();
        return super.getBinDistribution();
    }

    @Override
    public TestFile getGradleHomeDir() {
        this.download();
        return super.getGradleHomeDir();
    }

    private void download() {
        CACHE.getUnchecked((Object)new Key(this.getDownloadURL(), this.getBinDistribution(), this.versionDir));
        super.getBinDistribution().assertIsFile();
        super.getGradleHomeDir().assertIsDirectory();
    }

    protected abstract URL getDownloadURL();

    private static final class Key {
        private final URL url;
        private final TestFile binDistribution;
        private final TestFile versionDir;

        public Key(URL url, TestFile binDistribution, TestFile versionDir) {
            this.url = url;
            this.binDistribution = binDistribution;
            this.versionDir = versionDir;
        }

        public URL getUrl() {
            return this.url;
        }

        public TestFile getBinDistribution() {
            return this.binDistribution;
        }

        public TestFile getVersionDir() {
            return this.versionDir;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            URL this$url = this.getUrl();
            URL other$url = other.getUrl();
            if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
                return false;
            }
            TestFile this$binDistribution = this.getBinDistribution();
            TestFile other$binDistribution = other.getBinDistribution();
            if (this$binDistribution == null ? other$binDistribution != null : !((Object)this$binDistribution).equals(other$binDistribution)) {
                return false;
            }
            TestFile this$versionDir = this.getVersionDir();
            TestFile other$versionDir = other.getVersionDir();
            return !(this$versionDir == null ? other$versionDir != null : !((Object)this$versionDir).equals(other$versionDir));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            URL $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
            TestFile $binDistribution = this.getBinDistribution();
            result = result * 59 + ($binDistribution == null ? 43 : ((Object)$binDistribution).hashCode());
            TestFile $versionDir = this.getVersionDir();
            result = result * 59 + ($versionDir == null ? 43 : ((Object)$versionDir).hashCode());
            return result;
        }

        public String toString() {
            return "DownloadableGradleDistribution.Key(url=" + this.getUrl() + ", binDistribution=" + this.getBinDistribution() + ", versionDir=" + this.getVersionDir() + ")";
        }
    }
}

