/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.file;

import com.google.common.io.ByteStreams;
import dev.gradleplugins.test.fixtures.file.ExecOutput;
import dev.gradleplugins.test.fixtures.file.TestFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Expand;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class TestFileHelper {
    private final TestFile file;

    TestFileHelper(TestFile file) {
        this.file = file;
    }

    public void unzipTo(File target, boolean nativeTools) {
        try (FileInputStream instr = new FileInputStream(this.file);){
            HashSet<String> dirs = new HashSet<String>();
            try (ZipInputStream zipStr = new ZipInputStream(instr);){
                ZipEntry entry;
                while ((entry = zipStr.getNextEntry()) != null) {
                    if (entry.isDirectory()) {
                        Assert.assertTrue((String)("Duplicate directory '" + entry.getName() + "'"), (boolean)dirs.add(entry.getName()));
                    }
                    if (!entry.getName().contains("/")) continue;
                    String parent = StringUtils.substringBeforeLast((String)entry.getName(), (String)"/") + "/";
                    Assert.assertTrue((String)("Missing dir '" + parent + "'"), (boolean)dirs.contains(parent));
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (nativeTools && this.isUnix()) {
            try {
                Process process = new ProcessBuilder(new String[0]).command("unzip", "-q", "-o", this.file.getAbsolutePath(), "-d", target.getAbsolutePath()).inheritIO().start();
                Assert.assertThat((Object)process.waitFor(), (Matcher)CoreMatchers.equalTo((Object)0));
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        Expand unzip = new Expand();
        unzip.setSrc((File)this.file);
        unzip.setDest(target);
        unzip.setProject(new Project());
        unzip.execute();
    }

    private boolean isUnix() {
        return !SystemUtils.IS_OS_WINDOWS;
    }

    public ExecOutput exec(List<?> args) {
        return this.execute(args, null);
    }

    public ExecOutput execute(List<?> args, List<?> env) {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.file.getAbsolutePath());
        if (args != null) {
            commandLine.addAll(args.stream().map(Object::toString).collect(Collectors.toList()));
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(commandLine);
        if (env != null) {
            Map<String, String> environment = env.stream().map(TestFileHelper::toEntry).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            processBuilder.environment().putAll(environment);
        }
        try {
            Process process = processBuilder.start();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ByteArrayOutputStream error = new ByteArrayOutputStream();
            Thread outputThread = new Thread(() -> {
                try {
                    ByteStreams.copy((InputStream)process.getInputStream(), (OutputStream)output);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            outputThread.start();
            Thread errorThread = new Thread(() -> {
                try {
                    ByteStreams.copy((InputStream)process.getErrorStream(), (OutputStream)error);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            errorThread.start();
            try {
                int exitCode = process.waitFor();
                outputThread.join();
                errorThread.join();
                return new ExecOutput(exitCode, output.toString(), error.toString());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Map.Entry<String, String> toEntry(Object o) {
        String[] tokens = StringUtils.split((String)o.toString(), (String)"=", (int)2);
        if (tokens.length == 1) {
            return new AbstractMap.SimpleEntry<String, String>(tokens[0], "");
        }
        return new AbstractMap.SimpleEntry<String, String>(tokens[0], tokens[1]);
    }

    public ExecOutput executeSuccess(List<?> args, List<?> env) {
        ExecOutput result = this.execute(args, env);
        if (result.getExitCode() != 0) {
            throw new RuntimeException(String.format("Could not execute %s. Error: %s, Output: %s", this.file.getAbsolutePath(), result.getError(), result.getOut()));
        }
        return result;
    }

    public ExecOutput executeFailure(List<?> args, List<?> env) {
        ExecOutput result = this.execute(args, env);
        if (result.getExitCode() == 0) {
            throw new RuntimeException(String.format("Unexpected success, executing %s. Error: %s, Output: %s", this.file.getAbsolutePath(), result.getError(), result.getOut()));
        }
        return result;
    }
}

