/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.sources;

import dev.gradleplugins.test.fixtures.file.TestFile;
import dev.gradleplugins.test.fixtures.sources.Element;
import dev.gradleplugins.test.fixtures.sources.SourceFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class SourceElement
extends Element {
    public abstract List<SourceFile> getFiles();

    public String getSourceSetName() {
        return "main";
    }

    public void writeToProject(TestFile projectDir) {
        TestFile srcDir = projectDir.file("src/" + this.getSourceSetName());
        for (SourceFile sourceFile : this.getFiles()) {
            sourceFile.writeToDir(srcDir);
        }
    }

    public void writeToSourceDir(TestFile sourceDir) {
        for (SourceFile sourceFile : this.getFiles()) {
            sourceFile.writeToFile(sourceDir.file(sourceFile.getName()));
        }
    }

    public static SourceElement empty() {
        return new SourceElement(){

            @Override
            public List<SourceFile> getFiles() {
                return Collections.emptyList();
            }
        };
    }

    public static SourceElement ofElements(SourceElement ... elements) {
        return SourceElement.ofElements(Arrays.asList(elements));
    }

    public static SourceElement ofElements(final Iterable<SourceElement> elements) {
        return new SourceElement(){

            @Override
            public List<SourceFile> getFiles() {
                ArrayList<SourceFile> files = new ArrayList<SourceFile>();
                for (SourceElement element : elements) {
                    files.addAll(element.getFiles());
                }
                return files;
            }

            @Override
            public void writeToProject(TestFile projectDir) {
                for (SourceElement element : elements) {
                    element.writeToProject(projectDir);
                }
            }
        };
    }

    public static SourceElement ofFiles(final SourceFile ... files) {
        return new SourceElement(){

            @Override
            public List<SourceFile> getFiles() {
                return Arrays.asList(files);
            }
        };
    }

    public static SourceElement ofFiles(final List<SourceFile> files) {
        return new SourceElement(){

            @Override
            public List<SourceFile> getFiles() {
                return files;
            }
        };
    }

    public List<String> getSourceFileNames() {
        return this.getFiles().stream().map(SourceFile::getName).collect(Collectors.toList());
    }
}

