/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.archive;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

class ArchiveTestFixture {
    private final ListMultimap<String, String> filesByRelativePath = LinkedListMultimap.create();
    private final ListMultimap<String, Integer> fileModesByRelativePath = ArrayListMultimap.create();

    ArchiveTestFixture() {
    }

    protected void add(String relativePath, String content) {
        this.filesByRelativePath.put((Object)relativePath, (Object)content);
    }

    protected void addMode(String relativePath, int mode) {
        this.fileModesByRelativePath.put((Object)relativePath, (Object)(mode & 0x1FF));
    }

    public ArchiveTestFixture assertFileMode(String relativePath, int fileMode) {
        List modes = this.fileModesByRelativePath.get((Object)relativePath);
        assert (modes.size() == 1);
        Assert.assertThat(modes.get(0), (Matcher)CoreMatchers.equalTo((Object)fileMode));
        return this;
    }

    public ArchiveTestFixture assertContainsFile(String relativePath) {
        assert (this.filesByRelativePath.keySet().contains(relativePath));
        return this;
    }

    public ArchiveTestFixture assertNotContainsFile(String relativePath) {
        assert (!this.filesByRelativePath.keySet().contains(relativePath));
        return this;
    }

    public ArchiveTestFixture assertContainsFile(String relativePath, int occurrences) {
        this.assertContainsFile(relativePath);
        int actualOccurrences = this.filesByRelativePath.get((Object)relativePath).size();
        String failureMessage = String.format("Incorrect count for file '%s': expected %s, got %s", relativePath, occurrences, actualOccurrences);
        Assert.assertEquals((String)failureMessage, (long)occurrences, (long)actualOccurrences);
        return this;
    }

    public String content(String relativePath) {
        List files = this.filesByRelativePath.get((Object)relativePath);
        assert (files.size() == 1);
        return (String)files.get(0);
    }

    public Integer countFiles(String relativePath) {
        return this.filesByRelativePath.get((Object)relativePath).size();
    }

    public ArchiveTestFixture hasDescendants(String ... relativePaths) {
        return this.hasDescendants(Arrays.asList(relativePaths));
    }

    public ArchiveTestFixture hasDescendants(Collection<String> relativePaths) {
        Assert.assertThat((Object)this.filesByRelativePath.keySet(), (Matcher)CoreMatchers.equalTo(new HashSet<String>(relativePaths)));
        ArrayListMultimap expectedCounts = ArrayListMultimap.create();
        for (String fileName : relativePaths) {
            expectedCounts.put((Object)fileName, (Object)fileName);
        }
        for (String fileName : relativePaths) {
            Assert.assertEquals((long)expectedCounts.get((Object)fileName).size(), (long)this.filesByRelativePath.get((Object)fileName).size());
        }
        return this;
    }

    public ArchiveTestFixture hasDescendantsInOrder(String ... relativePaths) {
        List<String> expectedOrder = Arrays.asList(relativePaths);
        ArrayList actualOrder = new ArrayList(this.filesByRelativePath.keySet());
        Assert.assertEquals(actualOrder, expectedOrder);
        return this;
    }

    public ArchiveTestFixture containsDescendants(String ... relativePaths) {
        for (String path : relativePaths) {
            this.assertContainsFile(path);
        }
        return this;
    }

    public ArchiveTestFixture doesNotContainDescendants(String ... relativePaths) {
        for (String path : relativePaths) {
            this.assertNotContainsFile(path);
        }
        return this;
    }

    public ArchiveTestFixture assertFileContent(String relativePath, String fileContent) {
        return this.assertFileContent(relativePath, CoreMatchers.equalTo((Object)fileContent));
    }

    public ArchiveTestFixture assertFileContent(String relativePath, Matcher contentMatcher) {
        Assert.assertThat((Object)this.content(relativePath), (Matcher)contentMatcher);
        return this;
    }

    public ArchiveTestFixture assertFilePresent(String relativePath, String fileContent) {
        Assert.assertThat((Object)this.filesByRelativePath.get((Object)relativePath), (Matcher)CoreMatchers.hasItem((Object)fileContent));
        return this;
    }
}

