/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.archive;

import dev.gradleplugins.test.fixtures.archive.ZipTestFixture;
import dev.gradleplugins.test.fixtures.file.ClassFile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.gradle.api.JavaVersion;

public class JarTestFixture
extends ZipTestFixture {
    public final int classFileDescriptor = -889275714;
    public File file;

    public JarTestFixture(File file) {
        this(file, "UTF-8");
    }

    public JarTestFixture(File file, String metadataCharset) {
        this(file, "UTF-8", Charset.defaultCharset().name());
    }

    public JarTestFixture(File file, String metadataCharset, String contentCharset) {
        super(file, metadataCharset, contentCharset);
        this.file = file;
        this.isManifestPresentAndFirstEntry();
    }

    public JarTestFixture hasService(String serviceName, String serviceImpl) {
        this.assertFilePresent("META-INF/services/" + serviceName, serviceImpl);
        return this;
    }

    public void isManifestPresentAndFirstEntry() {
        try (ZipFile zipFile = new ZipFile(this.file, this.metadataCharset);){
            Enumeration entries = zipFile.getEntries();
            ZipEntry zipEntry = (ZipEntry)entries.nextElement();
            if (zipEntry.getName().equalsIgnoreCase("META-INF/")) {
                zipEntry = (ZipEntry)entries.nextElement();
            }
            String firstEntryName = zipEntry.getName();
            assert (firstEntryName.equalsIgnoreCase("META-INF/MANIFEST.MF"));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public JarTestFixture hasDescendants(String ... relativePaths) {
        ArrayList<String> allDescendants = new ArrayList<String>(Arrays.asList(relativePaths));
        allDescendants.add("META-INF/MANIFEST.MF");
        super.hasDescendants(allDescendants);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JavaVersion getJavaVersion() {
        try (JarFile jarFile = new JarFile(this.file);){
            JarEntry classEntry = Collections.list(jarFile.entries()).stream().filter(entry -> entry.getName().endsWith(".class")).findFirst().orElseThrow(() -> new RuntimeException("Could not find a class entry for: " + this.file));
            ClassFile classFile = new ClassFile(jarFile.getInputStream(classEntry));
            JavaVersion javaVersion = classFile.getJavaVersion();
            return javaVersion;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Manifest getManifest() {
        try {
            return new Manifest(new ByteArrayInputStream(this.content("META-INF/MANIFEST.MF").getBytes(this.contentCharset)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

