/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.archive;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import dev.gradleplugins.test.fixtures.archive.ArchiveTestFixture;
import dev.gradleplugins.test.fixtures.file.TestFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Enumeration;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class ZipTestFixture
extends ArchiveTestFixture {
    protected final String metadataCharset;
    protected final String contentCharset;

    public ZipTestFixture(File file) {
        this(file, Charset.defaultCharset().name());
    }

    public ZipTestFixture(File file, String metadataCharset) {
        this(file, metadataCharset, Charset.defaultCharset().name());
    }

    public ZipTestFixture(File file, String metadataCharset, String contentCharset) {
        new TestFile(file, new Object[0]).assertIsFile();
        this.metadataCharset = metadataCharset;
        this.contentCharset = contentCharset;
        try (ZipFile zipFile = new ZipFile(file, this.metadataCharset);){
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)entries.nextElement();
                String content = this.getContentForEntry(entry, zipFile);
                if (!entry.isDirectory()) {
                    this.add(entry.getName(), content);
                }
                this.addMode(entry.getName(), entry.getUnixMode());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String getContentForEntry(ZipEntry entry, ZipFile zipFile) {
        String extension = Files.getFileExtension((String)entry.getName());
        if (!Arrays.asList("jar", "zip").contains(extension)) {
            try {
                return new String(ByteStreams.toByteArray((InputStream)zipFile.getInputStream(entry)), this.contentCharset);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return "";
    }
}

