/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer.internal;

import dev.gradleplugins.test.fixtures.gradle.executer.GradleDistribution;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.artifacts.ivyservice.CacheLayout;
import org.gradle.cache.internal.CacheVersion;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.util.GradleVersion;

public abstract class AbstractGradleDistribution
implements GradleDistribution {
    private static final String DISABLE_HIGHEST_JAVA_VERSION = "org.gradle.java.version.disableHighest";

    @Override
    public boolean worksWith(Jvm jvm) {
        if (jvm.isIbmJvm() && this.isVersion("1.0-milestone-4")) {
            return false;
        }
        JavaVersion javaVersion = jvm.getJavaVersion();
        if (javaVersion == null) {
            throw new IllegalArgumentException();
        }
        return this.worksWith(javaVersion);
    }

    private boolean worksWith(JavaVersion javaVersion) {
        if (this.isVersion("0.9-rc-1") && javaVersion == JavaVersion.VERSION_1_5) {
            return false;
        }
        if (this.isSameOrOlder("1.0")) {
            return javaVersion.compareTo((Enum)JavaVersion.VERSION_1_5) >= 0 && javaVersion.compareTo((Enum)JavaVersion.VERSION_1_7) <= 0;
        }
        if (this.isSameOrOlder("1.12")) {
            return javaVersion.compareTo((Enum)JavaVersion.VERSION_1_5) >= 0 && javaVersion.compareTo((Enum)JavaVersion.VERSION_1_8) <= 0;
        }
        if (this.isSameOrOlder("3.0-milestone-1")) {
            return javaVersion.compareTo((Enum)JavaVersion.VERSION_1_6) >= 0 && javaVersion.compareTo((Enum)JavaVersion.VERSION_1_8) <= 0;
        }
        if (this.isSameOrOlder("4.6")) {
            return javaVersion.compareTo((Enum)JavaVersion.VERSION_1_7) >= 0 && javaVersion.compareTo((Enum)JavaVersion.VERSION_1_8) <= 0;
        }
        if (this.isSameOrOlder("4.10")) {
            return javaVersion.compareTo((Enum)JavaVersion.VERSION_1_7) >= 0 && javaVersion.compareTo((Enum)JavaVersion.VERSION_1_10) <= 0;
        }
        if (this.isSameOrOlder("5.7")) {
            return javaVersion.compareTo((Enum)JavaVersion.VERSION_1_8) >= 0 && javaVersion.compareTo((Enum)JavaVersion.VERSION_12) <= 0;
        }
        if (this.isSameOrOlder("6.0")) {
            return javaVersion.compareTo((Enum)JavaVersion.VERSION_1_8) >= 0 && javaVersion.compareTo((Enum)JavaVersion.VERSION_13) <= 0;
        }
        return javaVersion.compareTo((Enum)JavaVersion.VERSION_1_8) >= 0 && this.maybeEnforceHighestVersion(javaVersion, JavaVersion.VERSION_13);
    }

    @Override
    public boolean worksWith(OperatingSystem os) {
        if (this.isVersion("1.0-milestone-5")) {
            return os.isWindows() || os.isMacOsX() || os.isLinux();
        }
        return true;
    }

    private boolean maybeEnforceHighestVersion(JavaVersion javaVersion, JavaVersion highestVersion) {
        boolean disableHighest = System.getProperty(DISABLE_HIGHEST_JAVA_VERSION) != null;
        return disableHighest || javaVersion.compareTo((Enum)highestVersion) <= 0;
    }

    @Override
    public boolean isDaemonIdleTimeoutConfigurable() {
        return this.isSameOrNewer("1.0-milestone-7");
    }

    @Override
    public boolean isToolingApiSupported() {
        return this.isSameOrNewer("1.0-milestone-3");
    }

    @Override
    public boolean isToolingApiTargetJvmSupported(JavaVersion javaVersion) {
        return this.worksWith(javaVersion);
    }

    @Override
    public boolean isToolingApiLocksBuildActionClasses() {
        return this.isSameOrOlder("3.0");
    }

    @Override
    public boolean isToolingApiLoggingInEmbeddedModeSupported() {
        return this.isSameOrNewer("2.9-rc-1");
    }

    @Override
    public boolean isToolingApiStdinInEmbeddedModeSupported() {
        return this.isSameOrNewer("5.6-rc-1");
    }

    @Override
    public CacheVersion getArtifactCacheLayoutVersion() {
        if (this.isSameOrNewer("1.9-rc-2")) {
            return (CacheVersion)CacheLayout.META_DATA.getVersionMapping().getVersionUsedBy(this.getVersion()).get();
        }
        if (this.isSameOrNewer("1.9-rc-1")) {
            return CacheVersion.parse((String)"1.31");
        }
        if (this.isSameOrNewer("1.7-rc-1")) {
            return CacheVersion.parse((String)"0.26");
        }
        if (this.isSameOrNewer("1.6-rc-1")) {
            return CacheVersion.parse((String)"0.24");
        }
        if (this.isSameOrNewer("1.4-rc-1")) {
            return CacheVersion.parse((String)"0.23");
        }
        if (this.isSameOrNewer("1.3")) {
            return CacheVersion.parse((String)"0.15");
        }
        return CacheVersion.parse((String)"0.1");
    }

    @Override
    public boolean wrapperCanExecute(GradleVersion version) {
        if (version.equals((Object)GradleVersion.version((String)"0.8")) || this.isVersion("0.8")) {
            return false;
        }
        if (this.isVersion("0.9.1")) {
            return version.getVersion().matches(".*+\\d{4}");
        }
        return !this.isSameOrNewer("0.9.2") || !this.isSameOrOlder("1.0-milestone-2") || !version.getVersion().matches("1.0-milestone-\\d+[a-z]-.+");
    }

    @Override
    public boolean isWrapperSupportsGradleUserHomeCommandLineOption() {
        return this.isSameOrNewer("1.7");
    }

    @Override
    public boolean isSupportsSpacesInGradleAndJavaOpts() {
        return this.isSameOrNewer("1.0-milestone-5");
    }

    @Override
    public boolean isFullySupportsIvyRepository() {
        return this.isSameOrNewer("1.0-milestone-7");
    }

    @Override
    public boolean isAddsTaskExecutionExceptionAroundAllTaskFailures() {
        return this.isSameOrNewer("5.0");
    }

    @Override
    public boolean isToolingApiRetainsOriginalFailureOnCancel() {
        return this.isSameOrNewer("5.1-rc-1");
    }

    @Override
    public boolean isToolingApiDoesNotAddCausesOnTaskCancel() {
        return this.isSameOrNewer("5.1-rc-1");
    }

    @Override
    public boolean isToolingApiHasCauseOnCancel() {
        return this.isSameOrNewer("3.2") && (!this.isSameOrNewer("4.0") || !this.isSameOrOlder("4.0.2"));
    }

    @Override
    public boolean isToolingApiHasCauseOnForcedCancel() {
        return this.isSameOrNewer("5.1-rc-1");
    }

    @Override
    public boolean isToolingApiLogsFailureOnCancel() {
        return this.isSameOrNewer("4.1");
    }

    @Override
    public boolean isToolingApiHasCauseOnPhasedActionFail() {
        return this.isSameOrNewer("5.1-rc-1");
    }

    @Override
    public boolean isToolingApiMergesStderrIntoStdout() {
        return this.isSameOrNewer("4.7") && this.isSameOrOlder("5.0");
    }

    @Override
    public boolean isToolingApiLogsConfigureSummary() {
        return this.isSameOrNewer("2.14");
    }

    @Override
    public <T> T selectOutputWithFailureLogging(T stdout, T stderr) {
        if (this.isSameOrNewer("4.0") && this.isSameOrOlder("4.6") || this.isSameOrNewer("5.1-rc-1")) {
            return stderr;
        }
        return stdout;
    }

    protected boolean isSameOrNewer(String otherVersion) {
        return this.isVersion(otherVersion) || this.getVersion().compareTo(GradleVersion.version((String)otherVersion)) > 0;
    }

    protected boolean isSameOrOlder(String otherVersion) {
        return this.isVersion(otherVersion) || this.getVersion().compareTo(GradleVersion.version((String)otherVersion)) <= 0;
    }

    protected boolean isVersion(String otherVersionString) {
        GradleVersion otherVersion = GradleVersion.version((String)otherVersionString);
        return this.getVersion().compareTo(otherVersion) == 0 || this.getVersion().isSnapshot() && this.getVersion().getBaseVersion().equals((Object)otherVersion.getBaseVersion());
    }
}

