/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import dev.gradleplugins.test.fixtures.file.TestFile;
import dev.gradleplugins.test.fixtures.gradle.executer.ExecutionFailure;
import dev.gradleplugins.test.fixtures.gradle.executer.ExecutionResult;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleDistribution;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleExecuter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.GradleExecuterConfiguration;
import dev.gradleplugins.test.fixtures.gradle.logging.ConsoleOutput;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

abstract class AbstractGradleExecuter
implements GradleExecuter {
    protected GradleExecuterConfiguration configuration;
    private final TestFile testDirectory;

    public AbstractGradleExecuter(@NonNull GradleDistribution distribution, @NonNull TestFile testDirectory) {
        this(testDirectory, new GradleExecuterConfiguration(distribution));
        if (distribution == null) {
            throw new NullPointerException("distribution is marked non-null but is null");
        }
        if (testDirectory == null) {
            throw new NullPointerException("testDirectory is marked non-null but is null");
        }
    }

    protected AbstractGradleExecuter(TestFile testDirectory, GradleExecuterConfiguration configuration) {
        this.configuration = configuration;
        this.testDirectory = testDirectory;
    }

    protected GradleExecuter newInstance(GradleExecuterConfiguration configuration) {
        return this.newInstance(this.testDirectory, configuration);
    }

    protected abstract GradleExecuter newInstance(TestFile var1, GradleExecuterConfiguration var2);

    @Override
    public GradleDistribution getDistribution() {
        return this.configuration.getDistribution();
    }

    @Override
    public TestFile getTestDirectory() {
        return this.testDirectory;
    }

    @Override
    public File getWorkingDirectory() {
        return Optional.ofNullable(this.configuration.getWorkingDirectory()).orElse(this.testDirectory);
    }

    @Override
    public GradleExecuter inDirectory(File directory) {
        return this.newInstance(this.configuration.withWorkingDirectory(directory));
    }

    @Override
    public GradleExecuter withUserHomeDirectory(File userHomeDirectory) {
        return this.newInstance(this.configuration.withUserHomeDirectory(userHomeDirectory));
    }

    @Override
    public GradleExecuter withGradleUserHomeDirectory(File gradleUserHomeDirectory) {
        return this.newInstance(this.configuration.withGradleUserHomeDirectory(gradleUserHomeDirectory));
    }

    @Override
    public GradleExecuter requireOwnGradleUserHomeDirectory() {
        return this.newInstance(this.configuration.withGradleUserHomeDirectory(this.testDirectory.createDirectory("user-home")));
    }

    @Override
    public GradleExecuter withStacktraceDisabled() {
        return this.newInstance(this.configuration.withShowStacktrace(false));
    }

    @Override
    public GradleExecuter usingSettingsFile(File settingsFile) {
        return this.newInstance(this.configuration.withSettingsFile(settingsFile));
    }

    private void ensureSettingsFileAvailable() {
        TestFile workingDirectory;
        for (TestFile directory = workingDirectory = new TestFile(this.getWorkingDirectory(), new Object[0]); directory != null && this.getTestDirectory().isSelfOrDescendent(directory); directory = directory.getParentFile()) {
            if (!this.hasSettingsFile(directory)) continue;
            return;
        }
        workingDirectory.createFile("settings.gradle");
    }

    private boolean hasSettingsFile(TestFile directory) {
        if (directory.isDirectory()) {
            return directory.file("settings.gradle").isFile() || directory.file("settings.gradle.kts").isFile();
        }
        return false;
    }

    @Override
    public GradleExecuter usingBuildScript(File buildScript) {
        return this.newInstance(this.configuration.withBuildScript(buildScript));
    }

    @Override
    public GradleExecuter usingInitScript(File initScript) {
        return this.newInstance(this.configuration.withInitScripts((List<File>)ImmutableList.builder().addAll(this.configuration.getInitScripts()).add((Object)initScript).build()));
    }

    @Override
    public GradleExecuter usingProjectDirectory(File projectDirectory) {
        return this.newInstance(this.configuration.withProjectDirectory(projectDirectory));
    }

    @Override
    public GradleExecuter withBuildCacheEnabled() {
        return this.withArgument("--build-cache");
    }

    @Override
    public GradleExecuter withArguments(String ... args) {
        return this.withArguments(Arrays.asList(args));
    }

    @Override
    public GradleExecuter withArguments(List<String> args) {
        return this.newInstance(this.configuration.withArguments(args));
    }

    @Override
    public GradleExecuter withArgument(String arg) {
        return this.newInstance(this.configuration.withArguments((List<String>)ImmutableList.builder().addAll(this.configuration.getArguments()).add((Object)arg).build()));
    }

    @Override
    public GradleExecuter withTasks(String ... tasks) {
        return this.withTasks(Arrays.asList(tasks));
    }

    @Override
    public GradleExecuter withTasks(List<String> tasks) {
        return this.newInstance(this.configuration.withTasks((List<String>)ImmutableList.builder().addAll(this.configuration.getTasks()).addAll(tasks).build()));
    }

    @Override
    public GradleExecuter beforeExecute(Function<? super GradleExecuter, GradleExecuter> action) {
        return this.newInstance(this.configuration.withBeforeExecute((List<Function<? super GradleExecuter, GradleExecuter>>)ImmutableList.builder().addAll(this.configuration.getBeforeExecute()).add(action).build()));
    }

    private GradleExecuter fireBeforeExecute() {
        GradleExecuter executer = this.newInstance(this.configuration.withBeforeExecute((List<Function<? super GradleExecuter, GradleExecuter>>)ImmutableList.of()));
        for (Function<? super GradleExecuter, GradleExecuter> it : this.configuration.getBeforeExecute()) {
            executer = it.apply(executer);
        }
        return executer;
    }

    @Override
    public GradleExecuter afterExecute(Consumer<? super GradleExecuter> action) {
        return this.newInstance(this.configuration.withAfterExecute((List<Consumer<? super GradleExecuter>>)ImmutableList.builder().addAll(this.configuration.getAfterExecute()).add(action).build()));
    }

    private void fireAfterExecute() {
        this.configuration.getAfterExecute().forEach(it -> it.accept(this));
    }

    @Override
    public GradleExecuter withConsole(ConsoleOutput consoleType) {
        return this.newInstance(this.configuration.withConsoleType(consoleType));
    }

    @Override
    public GradleExecuter withEnvironmentVars(Map<String, ?> environment) {
        HashMap env = Maps.newHashMap(this.configuration.getEnvironment());
        env.putAll(environment);
        return this.newInstance(this.configuration.withEnvironment(env));
    }

    @Override
    public GradleExecuter withoutDeprecationChecks() {
        return this.newInstance(this.configuration.withAllowDeprecations(true));
    }

    @Override
    public ExecutionResult run() {
        if (this.configuration.getBeforeExecute().isEmpty()) {
            try {
                ExecutionResult result = this.doRun();
                this.fireAfterExecute();
                ExecutionResult executionResult = result;
                return executionResult;
            }
            finally {
                this.finished();
            }
        }
        return this.fireBeforeExecute().run();
    }

    protected abstract ExecutionResult doRun();

    @Override
    public ExecutionFailure runWithFailure() {
        if (this.configuration.getBeforeExecute().isEmpty()) {
            try {
                ExecutionFailure result = this.doRunWithFailure();
                this.fireAfterExecute();
                ExecutionFailure executionFailure = result;
                return executionFailure;
            }
            finally {
                this.finished();
            }
        }
        return this.fireBeforeExecute().runWithFailure();
    }

    protected abstract ExecutionFailure doRunWithFailure();

    private void finished() {
    }

    protected List<String> getAllArguments() {
        ArrayList<String> allArguments = new ArrayList<String>();
        allArguments.addAll(Optional.ofNullable(this.configuration.getUserHomeDirectory()).map(it -> Collections.singletonList("-Duser.home=" + it.getAbsolutePath())).orElse(Collections.emptyList()));
        allArguments.addAll(Optional.ofNullable(this.configuration.getBuildScript()).map(it -> Arrays.asList("--build-file", it.getAbsolutePath())).orElse(Collections.emptyList()));
        allArguments.addAll(Optional.ofNullable(this.configuration.getBuildScript()).map(it -> Arrays.asList("--project-dir", it.getAbsolutePath())).orElse(Collections.emptyList()));
        allArguments.addAll(Optional.ofNullable(this.configuration.getInitScripts()).map(it -> it.stream().flatMap(initScript -> Stream.of("--init-script", initScript.getAbsolutePath())).collect(Collectors.toList())).orElse(Collections.emptyList()));
        allArguments.addAll(Optional.ofNullable(this.configuration.getSettingsFile()).map(it -> Arrays.asList("--settings-file", it.getAbsolutePath())).orElse(Collections.emptyList()));
        allArguments.addAll(this.configuration.isShowStacktrace() ? Collections.singletonList("--stacktrace") : Collections.emptyList());
        if (this.configuration.getSettingsFile() == null) {
            this.ensureSettingsFileAvailable();
        }
        allArguments.addAll(Optional.ofNullable(this.configuration.getGradleUserHomeDirectory()).map(it -> Arrays.asList("--gradle-user-home", it.getAbsolutePath())).orElse(Collections.emptyList()));
        allArguments.addAll(Optional.ofNullable(this.configuration.getConsoleType()).map(it -> Arrays.asList("--console", it.toString().toLowerCase())).orElse(Collections.emptyList()));
        allArguments.addAll(this.configuration.isAllowDeprecations() ? Collections.emptyList() : Arrays.asList("--warning-mode", "fail"));
        allArguments.addAll(this.configuration.getArguments());
        allArguments.addAll(this.configuration.getTasks());
        return allArguments;
    }
}

