/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer.internal;

import dev.gradleplugins.test.fixtures.gradle.executer.GradleDistribution;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleExecuter;
import dev.gradleplugins.test.fixtures.gradle.logging.ConsoleOutput;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;

public class GradleExecuterConfiguration {
    private final GradleDistribution distribution;
    private File workingDirectory = null;
    private File userHomeDirectory = null;
    private File gradleUserHomeDirectory = null;
    private boolean showStacktrace = true;
    private File settingsFile = null;
    private File buildScript = null;
    @NonNull
    private List<File> initScripts = Collections.emptyList();
    private File projectDirectory = null;
    private boolean useBuildCache = false;
    @NonNull
    private List<String> arguments = Collections.emptyList();
    @NonNull
    private List<String> tasks = Collections.emptyList();
    @NonNull
    private Map<String, ?> environment = Collections.emptyMap();
    private ConsoleOutput consoleType = null;
    private boolean debuggerAttached = false;
    private boolean pluginClasspath = false;
    private String gradleVersion = null;
    @NonNull
    private List<Function<? super GradleExecuter, GradleExecuter>> beforeExecute = Collections.emptyList();
    @NonNull
    private List<Consumer<? super GradleExecuter>> afterExecute = Collections.emptyList();
    private boolean allowDeprecations = false;

    public GradleDistribution getDistribution() {
        return this.distribution;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public File getUserHomeDirectory() {
        return this.userHomeDirectory;
    }

    public File getGradleUserHomeDirectory() {
        return this.gradleUserHomeDirectory;
    }

    public boolean isShowStacktrace() {
        return this.showStacktrace;
    }

    public File getSettingsFile() {
        return this.settingsFile;
    }

    public File getBuildScript() {
        return this.buildScript;
    }

    @NonNull
    public List<File> getInitScripts() {
        return this.initScripts;
    }

    public File getProjectDirectory() {
        return this.projectDirectory;
    }

    public boolean isUseBuildCache() {
        return this.useBuildCache;
    }

    @NonNull
    public List<String> getArguments() {
        return this.arguments;
    }

    @NonNull
    public List<String> getTasks() {
        return this.tasks;
    }

    @NonNull
    public Map<String, ?> getEnvironment() {
        return this.environment;
    }

    public ConsoleOutput getConsoleType() {
        return this.consoleType;
    }

    public boolean isDebuggerAttached() {
        return this.debuggerAttached;
    }

    public boolean isPluginClasspath() {
        return this.pluginClasspath;
    }

    public String getGradleVersion() {
        return this.gradleVersion;
    }

    @NonNull
    public List<Function<? super GradleExecuter, GradleExecuter>> getBeforeExecute() {
        return this.beforeExecute;
    }

    @NonNull
    public List<Consumer<? super GradleExecuter>> getAfterExecute() {
        return this.afterExecute;
    }

    public boolean isAllowDeprecations() {
        return this.allowDeprecations;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setUserHomeDirectory(File userHomeDirectory) {
        this.userHomeDirectory = userHomeDirectory;
    }

    public void setGradleUserHomeDirectory(File gradleUserHomeDirectory) {
        this.gradleUserHomeDirectory = gradleUserHomeDirectory;
    }

    public void setShowStacktrace(boolean showStacktrace) {
        this.showStacktrace = showStacktrace;
    }

    public void setSettingsFile(File settingsFile) {
        this.settingsFile = settingsFile;
    }

    public void setBuildScript(File buildScript) {
        this.buildScript = buildScript;
    }

    public void setInitScripts(@NonNull List<File> initScripts) {
        if (initScripts == null) {
            throw new NullPointerException("initScripts is marked non-null but is null");
        }
        this.initScripts = initScripts;
    }

    public void setProjectDirectory(File projectDirectory) {
        this.projectDirectory = projectDirectory;
    }

    public void setUseBuildCache(boolean useBuildCache) {
        this.useBuildCache = useBuildCache;
    }

    public void setArguments(@NonNull List<String> arguments) {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        this.arguments = arguments;
    }

    public void setTasks(@NonNull List<String> tasks) {
        if (tasks == null) {
            throw new NullPointerException("tasks is marked non-null but is null");
        }
        this.tasks = tasks;
    }

    public void setEnvironment(@NonNull Map<String, ?> environment) {
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        this.environment = environment;
    }

    public void setConsoleType(ConsoleOutput consoleType) {
        this.consoleType = consoleType;
    }

    public void setDebuggerAttached(boolean debuggerAttached) {
        this.debuggerAttached = debuggerAttached;
    }

    public void setPluginClasspath(boolean pluginClasspath) {
        this.pluginClasspath = pluginClasspath;
    }

    public void setGradleVersion(String gradleVersion) {
        this.gradleVersion = gradleVersion;
    }

    public void setBeforeExecute(@NonNull List<Function<? super GradleExecuter, GradleExecuter>> beforeExecute) {
        if (beforeExecute == null) {
            throw new NullPointerException("beforeExecute is marked non-null but is null");
        }
        this.beforeExecute = beforeExecute;
    }

    public void setAfterExecute(@NonNull List<Consumer<? super GradleExecuter>> afterExecute) {
        if (afterExecute == null) {
            throw new NullPointerException("afterExecute is marked non-null but is null");
        }
        this.afterExecute = afterExecute;
    }

    public void setAllowDeprecations(boolean allowDeprecations) {
        this.allowDeprecations = allowDeprecations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleExecuterConfiguration)) {
            return false;
        }
        GradleExecuterConfiguration other = (GradleExecuterConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GradleDistribution this$distribution = this.getDistribution();
        GradleDistribution other$distribution = other.getDistribution();
        if (this$distribution == null ? other$distribution != null : !this$distribution.equals(other$distribution)) {
            return false;
        }
        File this$workingDirectory = this.getWorkingDirectory();
        File other$workingDirectory = other.getWorkingDirectory();
        if (this$workingDirectory == null ? other$workingDirectory != null : !((Object)this$workingDirectory).equals(other$workingDirectory)) {
            return false;
        }
        File this$userHomeDirectory = this.getUserHomeDirectory();
        File other$userHomeDirectory = other.getUserHomeDirectory();
        if (this$userHomeDirectory == null ? other$userHomeDirectory != null : !((Object)this$userHomeDirectory).equals(other$userHomeDirectory)) {
            return false;
        }
        File this$gradleUserHomeDirectory = this.getGradleUserHomeDirectory();
        File other$gradleUserHomeDirectory = other.getGradleUserHomeDirectory();
        if (this$gradleUserHomeDirectory == null ? other$gradleUserHomeDirectory != null : !((Object)this$gradleUserHomeDirectory).equals(other$gradleUserHomeDirectory)) {
            return false;
        }
        if (this.isShowStacktrace() != other.isShowStacktrace()) {
            return false;
        }
        File this$settingsFile = this.getSettingsFile();
        File other$settingsFile = other.getSettingsFile();
        if (this$settingsFile == null ? other$settingsFile != null : !((Object)this$settingsFile).equals(other$settingsFile)) {
            return false;
        }
        File this$buildScript = this.getBuildScript();
        File other$buildScript = other.getBuildScript();
        if (this$buildScript == null ? other$buildScript != null : !((Object)this$buildScript).equals(other$buildScript)) {
            return false;
        }
        List<File> this$initScripts = this.getInitScripts();
        List<File> other$initScripts = other.getInitScripts();
        if (this$initScripts == null ? other$initScripts != null : !((Object)this$initScripts).equals(other$initScripts)) {
            return false;
        }
        File this$projectDirectory = this.getProjectDirectory();
        File other$projectDirectory = other.getProjectDirectory();
        if (this$projectDirectory == null ? other$projectDirectory != null : !((Object)this$projectDirectory).equals(other$projectDirectory)) {
            return false;
        }
        if (this.isUseBuildCache() != other.isUseBuildCache()) {
            return false;
        }
        List<String> this$arguments = this.getArguments();
        List<String> other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        List<String> this$tasks = this.getTasks();
        List<String> other$tasks = other.getTasks();
        if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
            return false;
        }
        Map<String, ?> this$environment = this.getEnvironment();
        Map<String, ?> other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !((Object)this$environment).equals(other$environment)) {
            return false;
        }
        ConsoleOutput this$consoleType = this.getConsoleType();
        ConsoleOutput other$consoleType = other.getConsoleType();
        if (this$consoleType == null ? other$consoleType != null : !((Object)((Object)this$consoleType)).equals((Object)other$consoleType)) {
            return false;
        }
        if (this.isDebuggerAttached() != other.isDebuggerAttached()) {
            return false;
        }
        if (this.isPluginClasspath() != other.isPluginClasspath()) {
            return false;
        }
        String this$gradleVersion = this.getGradleVersion();
        String other$gradleVersion = other.getGradleVersion();
        if (this$gradleVersion == null ? other$gradleVersion != null : !this$gradleVersion.equals(other$gradleVersion)) {
            return false;
        }
        List<Function<? super GradleExecuter, GradleExecuter>> this$beforeExecute = this.getBeforeExecute();
        List<Function<? super GradleExecuter, GradleExecuter>> other$beforeExecute = other.getBeforeExecute();
        if (this$beforeExecute == null ? other$beforeExecute != null : !((Object)this$beforeExecute).equals(other$beforeExecute)) {
            return false;
        }
        List<Consumer<? super GradleExecuter>> this$afterExecute = this.getAfterExecute();
        List<Consumer<? super GradleExecuter>> other$afterExecute = other.getAfterExecute();
        if (this$afterExecute == null ? other$afterExecute != null : !((Object)this$afterExecute).equals(other$afterExecute)) {
            return false;
        }
        return this.isAllowDeprecations() == other.isAllowDeprecations();
    }

    protected boolean canEqual(Object other) {
        return other instanceof GradleExecuterConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GradleDistribution $distribution = this.getDistribution();
        result = result * 59 + ($distribution == null ? 43 : $distribution.hashCode());
        File $workingDirectory = this.getWorkingDirectory();
        result = result * 59 + ($workingDirectory == null ? 43 : ((Object)$workingDirectory).hashCode());
        File $userHomeDirectory = this.getUserHomeDirectory();
        result = result * 59 + ($userHomeDirectory == null ? 43 : ((Object)$userHomeDirectory).hashCode());
        File $gradleUserHomeDirectory = this.getGradleUserHomeDirectory();
        result = result * 59 + ($gradleUserHomeDirectory == null ? 43 : ((Object)$gradleUserHomeDirectory).hashCode());
        result = result * 59 + (this.isShowStacktrace() ? 79 : 97);
        File $settingsFile = this.getSettingsFile();
        result = result * 59 + ($settingsFile == null ? 43 : ((Object)$settingsFile).hashCode());
        File $buildScript = this.getBuildScript();
        result = result * 59 + ($buildScript == null ? 43 : ((Object)$buildScript).hashCode());
        List<File> $initScripts = this.getInitScripts();
        result = result * 59 + ($initScripts == null ? 43 : ((Object)$initScripts).hashCode());
        File $projectDirectory = this.getProjectDirectory();
        result = result * 59 + ($projectDirectory == null ? 43 : ((Object)$projectDirectory).hashCode());
        result = result * 59 + (this.isUseBuildCache() ? 79 : 97);
        List<String> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        List<String> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        Map<String, ?> $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : ((Object)$environment).hashCode());
        ConsoleOutput $consoleType = this.getConsoleType();
        result = result * 59 + ($consoleType == null ? 43 : ((Object)((Object)$consoleType)).hashCode());
        result = result * 59 + (this.isDebuggerAttached() ? 79 : 97);
        result = result * 59 + (this.isPluginClasspath() ? 79 : 97);
        String $gradleVersion = this.getGradleVersion();
        result = result * 59 + ($gradleVersion == null ? 43 : $gradleVersion.hashCode());
        List<Function<? super GradleExecuter, GradleExecuter>> $beforeExecute = this.getBeforeExecute();
        result = result * 59 + ($beforeExecute == null ? 43 : ((Object)$beforeExecute).hashCode());
        List<Consumer<? super GradleExecuter>> $afterExecute = this.getAfterExecute();
        result = result * 59 + ($afterExecute == null ? 43 : ((Object)$afterExecute).hashCode());
        result = result * 59 + (this.isAllowDeprecations() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "GradleExecuterConfiguration(distribution=" + this.getDistribution() + ", workingDirectory=" + this.getWorkingDirectory() + ", userHomeDirectory=" + this.getUserHomeDirectory() + ", gradleUserHomeDirectory=" + this.getGradleUserHomeDirectory() + ", showStacktrace=" + this.isShowStacktrace() + ", settingsFile=" + this.getSettingsFile() + ", buildScript=" + this.getBuildScript() + ", initScripts=" + this.getInitScripts() + ", projectDirectory=" + this.getProjectDirectory() + ", useBuildCache=" + this.isUseBuildCache() + ", arguments=" + this.getArguments() + ", tasks=" + this.getTasks() + ", environment=" + this.getEnvironment() + ", consoleType=" + (Object)((Object)this.getConsoleType()) + ", debuggerAttached=" + this.isDebuggerAttached() + ", pluginClasspath=" + this.isPluginClasspath() + ", gradleVersion=" + this.getGradleVersion() + ", beforeExecute=" + this.getBeforeExecute() + ", afterExecute=" + this.getAfterExecute() + ", allowDeprecations=" + this.isAllowDeprecations() + ")";
    }

    public GradleExecuterConfiguration(GradleDistribution distribution) {
        this.distribution = distribution;
    }

    public GradleExecuterConfiguration(GradleDistribution distribution, File workingDirectory, File userHomeDirectory, File gradleUserHomeDirectory, boolean showStacktrace, File settingsFile, File buildScript, @NonNull List<File> initScripts, File projectDirectory, boolean useBuildCache, @NonNull List<String> arguments, @NonNull List<String> tasks, @NonNull Map<String, ?> environment, ConsoleOutput consoleType, boolean debuggerAttached, boolean pluginClasspath, String gradleVersion, @NonNull List<Function<? super GradleExecuter, GradleExecuter>> beforeExecute, @NonNull List<Consumer<? super GradleExecuter>> afterExecute, boolean allowDeprecations) {
        if (initScripts == null) {
            throw new NullPointerException("initScripts is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        if (tasks == null) {
            throw new NullPointerException("tasks is marked non-null but is null");
        }
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        if (beforeExecute == null) {
            throw new NullPointerException("beforeExecute is marked non-null but is null");
        }
        if (afterExecute == null) {
            throw new NullPointerException("afterExecute is marked non-null but is null");
        }
        this.distribution = distribution;
        this.workingDirectory = workingDirectory;
        this.userHomeDirectory = userHomeDirectory;
        this.gradleUserHomeDirectory = gradleUserHomeDirectory;
        this.showStacktrace = showStacktrace;
        this.settingsFile = settingsFile;
        this.buildScript = buildScript;
        this.initScripts = initScripts;
        this.projectDirectory = projectDirectory;
        this.useBuildCache = useBuildCache;
        this.arguments = arguments;
        this.tasks = tasks;
        this.environment = environment;
        this.consoleType = consoleType;
        this.debuggerAttached = debuggerAttached;
        this.pluginClasspath = pluginClasspath;
        this.gradleVersion = gradleVersion;
        this.beforeExecute = beforeExecute;
        this.afterExecute = afterExecute;
        this.allowDeprecations = allowDeprecations;
    }

    public GradleExecuterConfiguration withWorkingDirectory(File workingDirectory) {
        return this.workingDirectory == workingDirectory ? this : new GradleExecuterConfiguration(this.distribution, workingDirectory, this.userHomeDirectory, this.gradleUserHomeDirectory, this.showStacktrace, this.settingsFile, this.buildScript, this.initScripts, this.projectDirectory, this.useBuildCache, this.arguments, this.tasks, this.environment, this.consoleType, this.debuggerAttached, this.pluginClasspath, this.gradleVersion, this.beforeExecute, this.afterExecute, this.allowDeprecations);
    }

    public GradleExecuterConfiguration withUserHomeDirectory(File userHomeDirectory) {
        return this.userHomeDirectory == userHomeDirectory ? this : new GradleExecuterConfiguration(this.distribution, this.workingDirectory, userHomeDirectory, this.gradleUserHomeDirectory, this.showStacktrace, this.settingsFile, this.buildScript, this.initScripts, this.projectDirectory, this.useBuildCache, this.arguments, this.tasks, this.environment, this.consoleType, this.debuggerAttached, this.pluginClasspath, this.gradleVersion, this.beforeExecute, this.afterExecute, this.allowDeprecations);
    }

    public GradleExecuterConfiguration withGradleUserHomeDirectory(File gradleUserHomeDirectory) {
        return this.gradleUserHomeDirectory == gradleUserHomeDirectory ? this : new GradleExecuterConfiguration(this.distribution, this.workingDirectory, this.userHomeDirectory, gradleUserHomeDirectory, this.showStacktrace, this.settingsFile, this.buildScript, this.initScripts, this.projectDirectory, this.useBuildCache, this.arguments, this.tasks, this.environment, this.consoleType, this.debuggerAttached, this.pluginClasspath, this.gradleVersion, this.beforeExecute, this.afterExecute, this.allowDeprecations);
    }

    public GradleExecuterConfiguration withShowStacktrace(boolean showStacktrace) {
        return this.showStacktrace == showStacktrace ? this : new GradleExecuterConfiguration(this.distribution, this.workingDirectory, this.userHomeDirectory, this.gradleUserHomeDirectory, showStacktrace, this.settingsFile, this.buildScript, this.initScripts, this.projectDirectory, this.useBuildCache, this.arguments, this.tasks, this.environment, this.consoleType, this.debuggerAttached, this.pluginClasspath, this.gradleVersion, this.beforeExecute, this.afterExecute, this.allowDeprecations);
    }

    public GradleExecuterConfiguration withSettingsFile(File settingsFile) {
        return this.settingsFile == settingsFile ? this : new GradleExecuterConfiguration(this.distribution, this.workingDirectory, this.userHomeDirectory, this.gradleUserHomeDirectory, this.showStacktrace, settingsFile, this.buildScript, this.initScripts, this.projectDirectory, this.useBuildCache, this.arguments, this.tasks, this.environment, this.consoleType, this.debuggerAttached, this.pluginClasspath, this.gradleVersion, this.beforeExecute, this.afterExecute, this.allowDeprecations);
    }

    public GradleExecuterConfiguration withBuildScript(File buildScript) {
        return this.buildScript == buildScript ? this : new GradleExecuterConfiguration(this.distribution, this.workingDirectory, this.userHomeDirectory, this.gradleUserHomeDirectory, this.showStacktrace, this.settingsFile, buildScript, this.initScripts, this.projectDirectory, this.useBuildCache, this.arguments, this.tasks, this.environment, this.consoleType, this.debuggerAttached, this.pluginClasspath, this.gradleVersion, this.beforeExecute, this.afterExecute, this.allowDeprecations);
    }

    public GradleExecuterConfiguration withInitScripts(@NonNull List<File> initScripts) {
        if (initScripts == null) {
            throw new NullPointerException("initScripts is marked non-null but is null");
        }
        return this.initScripts == initScripts ? this : new GradleExecuterConfiguration(this.distribution, this.workingDirectory, this.userHomeDirectory, this.gradleUserHomeDirectory, this.showStacktrace, this.settingsFile, this.buildScript, initScripts, this.projectDirectory, this.useBuildCache, this.arguments, this.tasks, this.environment, this.consoleType, this.debuggerAttached, this.pluginClasspath, this.gradleVersion, this.beforeExecute, this.afterExecute, this.allowDeprecations);
    }

    public GradleExecuterConfiguration withProjectDirectory(File projectDirectory) {
        return this.projectDirectory == projectDirectory ? this : new GradleExecuterConfiguration(this.distribution, this.workingDirectory, this.userHomeDirectory, this.gradleUserHomeDirectory, this.showStacktrace, this.settingsFile, this.buildScript, this.initScripts, projectDirectory, this.useBuildCache, this.arguments, this.tasks, this.environment, this.consoleType, this.debuggerAttached, this.pluginClasspath, this.gradleVersion, this.beforeExecute, this.afterExecute, this.allowDeprecations);
    }

    public GradleExecuterConfiguration withUseBuildCache(boolean useBuildCache) {
        return this.useBuildCache == useBuildCache ? this : new GradleExecuterConfiguration(this.distribution, this.workingDirectory, this.userHomeDirectory, this.gradleUserHomeDirectory, this.showStacktrace, this.settingsFile, this.buildScript, this.initScripts, this.projectDirectory, useBuildCache, this.arguments, this.tasks, this.environment, this.consoleType, this.debuggerAttached, this.pluginClasspath, this.gradleVersion, this.beforeExecute, this.afterExecute, this.allowDeprecations);
    }

    public GradleExecuterConfiguration withArguments(@NonNull List<String> arguments) {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        return this.arguments == arguments ? this : new GradleExecuterConfiguration(this.distribution, this.workingDirectory, this.userHomeDirectory, this.gradleUserHomeDirectory, this.showStacktrace, this.settingsFile, this.buildScript, this.initScripts, this.projectDirectory, this.useBuildCache, arguments, this.tasks, this.environment, this.consoleType, this.debuggerAttached, this.pluginClasspath, this.gradleVersion, this.beforeExecute, this.afterExecute, this.allowDeprecations);
    }

    public GradleExecuterConfiguration withTasks(@NonNull List<String> tasks) {
        if (tasks == null) {
            throw new NullPointerException("tasks is marked non-null but is null");
        }
        return this.tasks == tasks ? this : new GradleExecuterConfiguration(this.distribution, this.workingDirectory, this.userHomeDirectory, this.gradleUserHomeDirectory, this.showStacktrace, this.settingsFile, this.buildScript, this.initScripts, this.projectDirectory, this.useBuildCache, this.arguments, tasks, this.environment, this.consoleType, this.debuggerAttached, this.pluginClasspath, this.gradleVersion, this.beforeExecute, this.afterExecute, this.allowDeprecations);
    }

    public GradleExecuterConfiguration withEnvironment(@NonNull Map<String, ?> environment) {
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        return this.environment == environment ? this : new GradleExecuterConfiguration(this.distribution, this.workingDirectory, this.userHomeDirectory, this.gradleUserHomeDirectory, this.showStacktrace, this.settingsFile, this.buildScript, this.initScripts, this.projectDirectory, this.useBuildCache, this.arguments, this.tasks, environment, this.consoleType, this.debuggerAttached, this.pluginClasspath, this.gradleVersion, this.beforeExecute, this.afterExecute, this.allowDeprecations);
    }

    public GradleExecuterConfiguration withConsoleType(ConsoleOutput consoleType) {
        return this.consoleType == consoleType ? this : new GradleExecuterConfiguration(this.distribution, this.workingDirectory, this.userHomeDirectory, this.gradleUserHomeDirectory, this.showStacktrace, this.settingsFile, this.buildScript, this.initScripts, this.projectDirectory, this.useBuildCache, this.arguments, this.tasks, this.environment, consoleType, this.debuggerAttached, this.pluginClasspath, this.gradleVersion, this.beforeExecute, this.afterExecute, this.allowDeprecations);
    }

    public GradleExecuterConfiguration withDebuggerAttached(boolean debuggerAttached) {
        return this.debuggerAttached == debuggerAttached ? this : new GradleExecuterConfiguration(this.distribution, this.workingDirectory, this.userHomeDirectory, this.gradleUserHomeDirectory, this.showStacktrace, this.settingsFile, this.buildScript, this.initScripts, this.projectDirectory, this.useBuildCache, this.arguments, this.tasks, this.environment, this.consoleType, debuggerAttached, this.pluginClasspath, this.gradleVersion, this.beforeExecute, this.afterExecute, this.allowDeprecations);
    }

    public GradleExecuterConfiguration withPluginClasspath(boolean pluginClasspath) {
        return this.pluginClasspath == pluginClasspath ? this : new GradleExecuterConfiguration(this.distribution, this.workingDirectory, this.userHomeDirectory, this.gradleUserHomeDirectory, this.showStacktrace, this.settingsFile, this.buildScript, this.initScripts, this.projectDirectory, this.useBuildCache, this.arguments, this.tasks, this.environment, this.consoleType, this.debuggerAttached, pluginClasspath, this.gradleVersion, this.beforeExecute, this.afterExecute, this.allowDeprecations);
    }

    public GradleExecuterConfiguration withGradleVersion(String gradleVersion) {
        return this.gradleVersion == gradleVersion ? this : new GradleExecuterConfiguration(this.distribution, this.workingDirectory, this.userHomeDirectory, this.gradleUserHomeDirectory, this.showStacktrace, this.settingsFile, this.buildScript, this.initScripts, this.projectDirectory, this.useBuildCache, this.arguments, this.tasks, this.environment, this.consoleType, this.debuggerAttached, this.pluginClasspath, gradleVersion, this.beforeExecute, this.afterExecute, this.allowDeprecations);
    }

    public GradleExecuterConfiguration withBeforeExecute(@NonNull List<Function<? super GradleExecuter, GradleExecuter>> beforeExecute) {
        if (beforeExecute == null) {
            throw new NullPointerException("beforeExecute is marked non-null but is null");
        }
        return this.beforeExecute == beforeExecute ? this : new GradleExecuterConfiguration(this.distribution, this.workingDirectory, this.userHomeDirectory, this.gradleUserHomeDirectory, this.showStacktrace, this.settingsFile, this.buildScript, this.initScripts, this.projectDirectory, this.useBuildCache, this.arguments, this.tasks, this.environment, this.consoleType, this.debuggerAttached, this.pluginClasspath, this.gradleVersion, beforeExecute, this.afterExecute, this.allowDeprecations);
    }

    public GradleExecuterConfiguration withAfterExecute(@NonNull List<Consumer<? super GradleExecuter>> afterExecute) {
        if (afterExecute == null) {
            throw new NullPointerException("afterExecute is marked non-null but is null");
        }
        return this.afterExecute == afterExecute ? this : new GradleExecuterConfiguration(this.distribution, this.workingDirectory, this.userHomeDirectory, this.gradleUserHomeDirectory, this.showStacktrace, this.settingsFile, this.buildScript, this.initScripts, this.projectDirectory, this.useBuildCache, this.arguments, this.tasks, this.environment, this.consoleType, this.debuggerAttached, this.pluginClasspath, this.gradleVersion, this.beforeExecute, afterExecute, this.allowDeprecations);
    }

    public GradleExecuterConfiguration withAllowDeprecations(boolean allowDeprecations) {
        return this.allowDeprecations == allowDeprecations ? this : new GradleExecuterConfiguration(this.distribution, this.workingDirectory, this.userHomeDirectory, this.gradleUserHomeDirectory, this.showStacktrace, this.settingsFile, this.buildScript, this.initScripts, this.projectDirectory, this.useBuildCache, this.arguments, this.tasks, this.environment, this.consoleType, this.debuggerAttached, this.pluginClasspath, this.gradleVersion, this.beforeExecute, this.afterExecute, allowDeprecations);
    }
}

