/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer.internal;

import dev.gradleplugins.test.fixtures.file.TestFile;
import dev.gradleplugins.test.fixtures.gradle.executer.ExecutionFailure;
import dev.gradleplugins.test.fixtures.gradle.executer.ExecutionResult;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleDistribution;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleExecuter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.AbstractGradleExecuter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.GradleExecuterConfiguration;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.LogContent;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.OutputCapturer;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.OutputScrapingExecutionFailure;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.OutputScrapingExecutionResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;

public class OutOfProcessGradleExecuter
extends AbstractGradleExecuter {
    public OutOfProcessGradleExecuter(GradleDistribution distribution, TestFile testDirectory) {
        super(distribution, testDirectory);
    }

    OutOfProcessGradleExecuter(TestFile testDirectory, GradleExecuterConfiguration configuration) {
        super(testDirectory, configuration);
    }

    @Override
    protected GradleExecuter newInstance(TestFile testDirectory, GradleExecuterConfiguration configuration) {
        return new OutOfProcessGradleExecuter(testDirectory, configuration);
    }

    @Override
    public GradleExecuter requireGradleDistribution() {
        return this;
    }

    protected GradleHandle createHandle() {
        try {
            ArrayList<String> command = new ArrayList<String>();
            if (SystemUtils.IS_OS_WINDOWS) {
                command.addAll(Arrays.asList("cmd", "/c", this.getDistribution().getBinaryDirectory().file("gradle.bat").getAbsolutePath()));
            } else {
                command.add(this.getDistribution().getBinaryDirectory().file("gradle").getAbsolutePath());
            }
            command.addAll(this.getAllArguments());
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(command).directory(this.getWorkingDirectory());
            if (!this.configuration.getEnvironment().isEmpty()) {
                processBuilder.environment().putAll(this.configuration.getEnvironment().entrySet().stream().map(it -> new AbstractMap.SimpleEntry(it.getKey(), it.getValue().toString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            }
            OutputCapturer standardOutputCapturer = OutOfProcessGradleExecuter.outputCapturerFor(System.out, Charset.defaultCharset());
            OutputCapturer errorOutputCapturer = OutOfProcessGradleExecuter.outputCapturerFor(System.err, Charset.defaultCharset());
            Process process = processBuilder.start();
            Thread outStream = new Thread(new StreamRunner(process.getInputStream(), standardOutputCapturer.getOutputStream()));
            Thread errStream = new Thread(new StreamRunner(process.getErrorStream(), errorOutputCapturer.getOutputStream()));
            outStream.start();
            errStream.start();
            return new GradleHandle(process, outStream, errStream, standardOutputCapturer::getOutputAsString, errorOutputCapturer::getOutputAsString);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ExecutionResult doRun() {
        try {
            GradleHandle handle = this.createHandle();
            if (0 != handle.waitFor()) {
                throw new RuntimeException("Build failure (" + handle.process.exitValue() + ")");
            }
            handle.stdout.join();
            handle.stderr.join();
            return new OutputScrapingExecutionResult(LogContent.of((String)handle.output.get()), LogContent.of((String)handle.error.get()), true);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static OutputCapturer outputCapturerFor(PrintStream stream, Charset outputEncoding) {
        return new OutputCapturer(stream, outputEncoding);
    }

    @Override
    protected ExecutionFailure doRunWithFailure() {
        try {
            GradleHandle handle = this.createHandle();
            if (0 == handle.waitFor()) {
                throw new RuntimeException("Build succeeded (" + handle.process.exitValue() + ")");
            }
            handle.stdout.join();
            handle.stderr.join();
            return new OutputScrapingExecutionFailure((String)handle.output.get(), (String)handle.error.get(), true);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public GradleExecuter withDebuggerAttached() {
        throw new UnsupportedOperationException();
    }

    @Override
    public GradleExecuter withPluginClasspath() {
        throw new UnsupportedOperationException();
    }

    private static class StreamRunner
    implements Runnable {
        private final InputStream inputStream;
        private final OutputStream outputStream;

        public StreamRunner(InputStream inputStream, OutputStream outputStream) {
            this.inputStream = inputStream;
            this.outputStream = outputStream;
        }

        @Override
        public void run() {
            try {
                IOUtils.copy((InputStream)this.inputStream, (OutputStream)this.outputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static class GradleHandle {
        private final Process process;
        private final Thread stdout;
        private final Thread stderr;
        private final Supplier<String> output;
        private final Supplier<String> error;

        public int waitFor() {
            try {
                return this.process.waitFor();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public GradleHandle(Process process, Thread stdout, Thread stderr, Supplier<String> output, Supplier<String> error) {
            this.process = process;
            this.stdout = stdout;
            this.stderr = stderr;
            this.output = output;
            this.error = error;
        }
    }
}

