/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer.internal;

import dev.gradleplugins.test.fixtures.Pair;
import dev.gradleplugins.test.fixtures.gradle.executer.ExecutionResult;
import dev.gradleplugins.test.fixtures.gradle.executer.TaskOrderSpecs;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.AnyOrderOutputMatcher;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.LogContent;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.OutputScrapingExecutionFailure;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.SequentialOutputMatcher;
import dev.gradleplugins.test.fixtures.gradle.logging.GroupedOutputFixture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ComparisonFailure;

public class OutputScrapingExecutionResult
implements ExecutionResult {
    static final Pattern STACK_TRACE_ELEMENT = Pattern.compile("\\s+(at\\s+)?([\\w.$_]+/)?[\\w.$_]+\\.[\\w$_ =\\+'-<>]+\\(.+?\\)(\\x1B\\[0K)?");
    private static final String TASK_PREFIX = "> Task ";
    private static final Pattern SKIPPED_TASK_PATTERN = Pattern.compile("(> Task )?(:\\S+?(:\\S+?)*)\\s+((SKIPPED)|(UP-TO-DATE)|(NO-SOURCE)|(FROM-CACHE))");
    private static final Pattern TASK_PATTERN = Pattern.compile("(> Task )?(:\\S+?(:\\S+?)*)((\\s+SKIPPED)|(\\s+UP-TO-DATE)|(\\s+FROM-CACHE)|(\\s+NO-SOURCE)|(\\s+FAILED)|(\\s*))");
    private static final Pattern BUILD_RESULT_PATTERN = Pattern.compile("BUILD (SUCCESSFUL|FAILED) in( \\d+m?[smh])+");
    private final LogContent output;
    private final LogContent error;
    private boolean includeBuildSrc;
    private final LogContent mainContent;
    private final LogContent postBuild;
    private final LogContent errorContent;
    private GroupedOutputFixture groupedOutputFixture;
    private Set<String> tasks;

    public static List<String> flattenTaskPaths(Object[] taskPaths) {
        ArrayList<String> result = new ArrayList<String>();
        OutputScrapingExecutionResult.flattenTaskPaths(Arrays.asList(taskPaths), result);
        return result;
    }

    private static void flattenTaskPaths(Collection<? super Object> taskPaths, List<String> flattenTaskPaths) {
        taskPaths.stream().forEach(it -> {
            if (it instanceof Collection) {
                OutputScrapingExecutionResult.flattenTaskPaths((Collection)it, flattenTaskPaths);
            } else {
                flattenTaskPaths.add(it.toString());
            }
        });
    }

    public static OutputScrapingExecutionResult from(String output, String error) {
        if (output.contains("BUILD FAILED") || output.contains("FAILURE: Build failed with an exception.") || error.contains("BUILD FAILED")) {
            return new OutputScrapingExecutionFailure(output, error, true);
        }
        return new OutputScrapingExecutionResult(LogContent.of(output), LogContent.of(error), true);
    }

    protected OutputScrapingExecutionResult(LogContent output, LogContent error, boolean includeBuildSrc) {
        this.output = output;
        this.error = error;
        this.includeBuildSrc = includeBuildSrc;
        LogContent filteredOutput = this.output.ansiCharsToPlainText().removeDebugPrefix();
        Pair<LogContent, LogContent> match = filteredOutput.splitOnFirstMatchingLine(BUILD_RESULT_PATTERN);
        if (match == null) {
            this.mainContent = filteredOutput;
            this.postBuild = LogContent.empty();
        } else {
            this.mainContent = match.getLeft();
            this.postBuild = match.getRight().drop(1);
        }
        this.errorContent = error.ansiCharsToPlainText();
    }

    public ExecutionResult getIgnoreBuildSrc() {
        return new OutputScrapingExecutionResult(this.output, this.error, false);
    }

    @Override
    public String getOutput() {
        return this.output.withNormalizedEol();
    }

    public LogContent getMainContent() {
        return this.mainContent;
    }

    public String getNormalizedOutput() {
        return OutputScrapingExecutionResult.normalize(this.output);
    }

    public String getFormattedOutput() {
        return this.output.ansiCharsToColorText().withNormalizedEol();
    }

    @Override
    public String getPlainTextOutput() {
        return this.output.ansiCharsToPlainText().withNormalizedEol();
    }

    @Override
    public GroupedOutputFixture getGroupedOutput() {
        if (this.groupedOutputFixture == null) {
            this.groupedOutputFixture = new GroupedOutputFixture(this.getMainContent());
        }
        return this.groupedOutputFixture;
    }

    public static String normalize(LogContent output) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> lines = output.getLines();
        int i = 0;
        while (i < lines.size()) {
            String line = lines.get(i);
            if (line.contains("Starting a Gradle Daemon")) {
                ++i;
                continue;
            }
            if (line.contains("Daemon will be stopped at the end of the build ")) {
                ++i;
                continue;
            }
            if (line.contains("Expiring Daemon because JVM heap space is exhausted")) {
                ++i;
                continue;
            }
            if (line.contains("Deprecated Gradle features were used in this build, making it incompatible with Gradle")) {
                i += 4;
                continue;
            }
            if (BUILD_RESULT_PATTERN.matcher(line).matches()) {
                result.add(BUILD_RESULT_PATTERN.matcher(line).replaceFirst("BUILD $1 in 0s"));
                ++i;
                continue;
            }
            result.add(line);
            ++i;
        }
        return LogContent.of(result).withNormalizedEol();
    }

    public ExecutionResult assertOutputEquals(String expectedOutput, boolean ignoreExtraLines, boolean ignoreLineOrder) {
        SequentialOutputMatcher matcher = ignoreLineOrder ? new AnyOrderOutputMatcher() : new SequentialOutputMatcher();
        matcher.assertOutputMatches(expectedOutput, this.getNormalizedOutput(), ignoreExtraLines);
        return this;
    }

    @Override
    public ExecutionResult assertHasPostBuildOutput(String expectedOutput) {
        return this.assertContentContains(this.postBuild.withNormalizedEol(), expectedOutput, "Post-build output");
    }

    @Override
    public ExecutionResult assertNotOutput(String expectedOutput) {
        String expectedText = LogContent.of(expectedOutput).withNormalizedEol();
        if (this.getOutput().contains(expectedText) || this.getError().contains(expectedText)) {
            this.failureOnUnexpectedOutput(String.format("Found unexpected text in build output.%nExpected not present: %s%n", expectedText));
        }
        return this;
    }

    public ExecutionResult assertContentContains(String actualText, String expectedOutput, String label) {
        String expectedText = LogContent.of(expectedOutput).withNormalizedEol();
        if (!actualText.contains(expectedText)) {
            this.failOnMissingOutput("Did not find expected text in " + label.toLowerCase() + ".", label, expectedOutput, actualText);
        }
        return this;
    }

    @Override
    public ExecutionResult assertThatOutput(Matcher<? super String> matcher) {
        Assert.assertThat((String)"Output did not match!", (Object)this.getMainContent().withNormalizedEol(), matcher);
        return this;
    }

    @Override
    public ExecutionResult assertOutputContains(String expectedOutput) {
        return this.assertContentContains(this.getMainContent().withNormalizedEol(), expectedOutput, "Build output");
    }

    public boolean hasErrorOutput(String expectedOutput) {
        return this.getError().contains(expectedOutput);
    }

    public ExecutionResult assertHasErrorOutput(String expectedOutput) {
        return this.assertContentContains(this.errorContent.withNormalizedEol(), expectedOutput, "Error output");
    }

    public String getError() {
        return this.error.withNormalizedEol();
    }

    public String getOutputLineThatContains(String text) {
        Optional<String> foundLine = this.getMainContent().getLines().stream().filter(line -> line.contains(text)).findFirst();
        return foundLine.orElseGet(() -> {
            this.failOnMissingOutput("Did not find expected text in build output.", "Build output", text, text);
            return "";
        });
    }

    public List<String> getExecutedTasks() {
        return Collections.unmodifiableList(new ArrayList<String>(this.findExecutedTasksInOrderStarted()));
    }

    private Set<String> findExecutedTasksInOrderStarted() {
        if (this.tasks == null) {
            this.tasks = new LinkedHashSet<String>(this.grepTasks(TASK_PATTERN));
        }
        return this.tasks;
    }

    public ExecutionResult assertTasksExecutedInOrder(Object ... taskPaths) {
        Set<String> allTasks = TaskOrderSpecs.exact(taskPaths).getTasks();
        this.assertTasksExecuted(allTasks);
        this.assertTaskOrder(taskPaths);
        return this;
    }

    @Override
    public ExecutionResult assertTasksExecuted(Object ... taskPaths) {
        Set<String> actualTasks;
        TreeSet<String> expectedTasks = new TreeSet<String>(OutputScrapingExecutionResult.flattenTaskPaths(taskPaths));
        if (!expectedTasks.equals(actualTasks = this.findExecutedTasksInOrderStarted())) {
            this.failOnDifferentSets("Build output does not contain the expected tasks.", expectedTasks, actualTasks);
        }
        return this;
    }

    @Override
    public ExecutionResult assertTasksExecutedAndNotSkipped(Object ... taskPaths) {
        this.assertTasksExecuted(taskPaths);
        return this.assertTasksNotSkipped(taskPaths);
    }

    public ExecutionResult assertTaskExecuted(String taskPath) {
        Set<String> actualTasks = this.findExecutedTasksInOrderStarted();
        if (!actualTasks.contains(taskPath)) {
            this.failOnMissingElement("Build output does not contain the expected task.", taskPath, actualTasks);
        }
        return this;
    }

    @Override
    public ExecutionResult assertTaskNotExecuted(String taskPath) {
        Set<String> actualTasks = this.findExecutedTasksInOrderStarted();
        if (actualTasks.contains(taskPath)) {
            this.failOnMissingElement("Build output does contains unexpected task.", taskPath, actualTasks);
        }
        return this;
    }

    public ExecutionResult assertTaskOrder(Object ... taskPaths) {
        TaskOrderSpecs.exact(taskPaths).assertMatches(-1, this.getExecutedTasks());
        return this;
    }

    public Set<String> getSkippedTasks() {
        return new TreeSet<String>(this.grepTasks(SKIPPED_TASK_PATTERN));
    }

    @Override
    public ExecutionResult assertTasksSkipped(Object ... taskPaths) {
        Set<String> skippedTasks;
        TreeSet<String> expectedTasks = new TreeSet<String>(OutputScrapingExecutionResult.flattenTaskPaths(taskPaths));
        if (!expectedTasks.equals(skippedTasks = this.getSkippedTasks())) {
            this.failOnDifferentSets("Build output does not contain the expected skipped tasks.", expectedTasks, skippedTasks);
        }
        return this;
    }

    @Override
    public ExecutionResult assertTaskSkipped(String taskPath) {
        TreeSet<String> tasks = new TreeSet<String>(this.getSkippedTasks());
        if (!tasks.contains(taskPath)) {
            this.failOnMissingElement("Build output does not contain the expected skipped task.", taskPath, tasks);
        }
        return this;
    }

    private Collection<String> getNotSkippedTasks() {
        TreeSet<String> all = new TreeSet<String>(this.getExecutedTasks());
        Set<String> skipped = this.getSkippedTasks();
        all.removeAll(skipped);
        return all;
    }

    @Override
    public ExecutionResult assertTasksNotSkipped(Object ... taskPaths) {
        TreeSet<String> tasks;
        TreeSet<String> expectedTasks = new TreeSet<String>(OutputScrapingExecutionResult.flattenTaskPaths(taskPaths));
        if (!expectedTasks.equals(tasks = new TreeSet<String>(this.getNotSkippedTasks()))) {
            this.failOnDifferentSets("Build output does not contain the expected non skipped tasks.", expectedTasks, tasks);
        }
        return this;
    }

    @Override
    public ExecutionResult assertTaskNotSkipped(String taskPath) {
        TreeSet<String> tasks = new TreeSet<String>(this.getNotSkippedTasks());
        if (!tasks.contains(taskPath)) {
            this.failOnMissingElement("Build output does not contain the expected non skipped task.", taskPath, tasks);
        }
        return this;
    }

    private void failOnDifferentSets(String message, Set<String> expected, Set<String> actual) {
        this.failureOnUnexpectedOutput(String.format("%s%nExpected: %s%nActual: %s", message, expected, actual));
    }

    private void failOnMissingElement(String message, String expected, Set<String> actual) {
        this.failureOnUnexpectedOutput(String.format("%s%nExpected: %s%nActual: %s", message, expected, actual));
    }

    private void failOnMissingOutput(String message, String type, String expected, String actual) {
        throw new ComparisonFailure(this.unexpectedOutputMessage(String.format("%s%nExpected: %s%n%n%s:%n=======%n%s", message, expected, type, actual)), expected, actual);
    }

    protected void failureOnUnexpectedOutput(String message) {
        throw new AssertionError((Object)this.unexpectedOutputMessage(message));
    }

    private String unexpectedOutputMessage(String message) {
        return String.format("%s%nOutput:%n=======%n%s%nError:%n======%n%s", message, this.getOutput(), this.getError());
    }

    private List<String> grepTasks(final Pattern pattern) {
        final ArrayList<String> tasks = new ArrayList<String>();
        final ArrayList taskStatusLines = new ArrayList();
        this.getMainContent().eachLine((Consumer<? super String>)new Consumer<String>(){

            @Override
            public void accept(String line) {
                java.util.regex.Matcher matcher = pattern.matcher(line);
                if (matcher.matches()) {
                    String previousTaskStatusLine;
                    String taskStatusLine = matcher.group().replace(OutputScrapingExecutionResult.TASK_PREFIX, "");
                    String taskName = matcher.group(2);
                    if (!OutputScrapingExecutionResult.this.includeBuildSrc && taskName.startsWith(":buildSrc:")) {
                        return;
                    }
                    String string = previousTaskStatusLine = tasks.contains(taskName) ? (String)taskStatusLines.get(tasks.lastIndexOf(taskName)) : "";
                    if (previousTaskStatusLine.equals(taskName) && !taskStatusLine.equals(taskName)) {
                        return;
                    }
                    taskStatusLines.add(taskStatusLine);
                    tasks.add(taskName);
                }
            }
        });
        return tasks;
    }
}

