/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.internal.jvm.Jvm;
import org.gradle.util.TextUtil;
import org.junit.Assert;

public class SequentialOutputMatcher {
    public void assertOutputMatches(String expected, String actual, boolean ignoreExtraLines) {
        List<String> actualLines = this.normaliseOutput(SequentialOutputMatcher.readLines(actual)).stream().filter(it -> !it.isEmpty()).collect(Collectors.toList());
        List<String> expectedLines = SequentialOutputMatcher.readLines(expected).stream().filter(it -> !it.isEmpty()).collect(Collectors.toList());
        this.assertOutputLinesMatch(expectedLines, actualLines, ignoreExtraLines, actual);
    }

    private static List<String> readLines(String v) {
        return Arrays.asList(v.split("\\r?\\n", -1));
    }

    protected void assertOutputLinesMatch(List<String> expectedLines, List<String> actualLines, boolean ignoreExtraLines, String actual) {
        int pos;
        for (pos = 0; pos < actualLines.size() && pos < expectedLines.size(); ++pos) {
            String actualLine;
            String expectedLine = expectedLines.get(pos);
            boolean matches = this.compare(expectedLine, actualLine = actualLines.get(pos));
            if (matches) continue;
            if (expectedLine.contains(actualLine)) {
                Assert.fail((String)String.format("Missing text at line %d.%nExpected: %s%nActual: %s%n---%nActual output:%n%s%n---", pos + 1, expectedLine, actualLine, actual));
            }
            if (actualLine.contains(expectedLine)) {
                Assert.fail((String)String.format("Extra text at line %d.%nExpected: %s%nActual: %s%n---%nActual output:%n%s%n---", pos + 1, expectedLine, actualLine, actual));
            }
            Assert.fail((String)String.format("Unexpected value at line %d.%nExpected: %s%nActual: %s%n---%nActual output:%n$actual%n---", pos + 1, expectedLine, actualLine, actual));
        }
        if (pos == actualLines.size() && pos < expectedLines.size()) {
            Assert.fail((String)String.format("Lines missing from actual result, starting at line %d.%nExpected: %s%nActual output:%n%s%n---", pos + 1, expectedLines.get(pos), actual));
        }
        if (!ignoreExtraLines && pos < actualLines.size() && pos == expectedLines.size()) {
            Assert.fail((String)String.format("Extra lines in actual result, starting at line %d.%nActual: %s%nActual output:%n%s%n---", pos + 1, actualLines.get(pos), actual));
        }
    }

    private List<String> normaliseOutput(List<String> lines) {
        if (lines.isEmpty()) {
            return lines;
        }
        boolean seenWarning = false;
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines) {
            if (line.matches("Download .+")) continue;
            if (!seenWarning && !Jvm.current().getJavaVersion().isJava7Compatible() && line == "Support for reading or changing file permissions is only available on this platform using Java 7 or later.") {
                seenWarning = true;
                continue;
            }
            result.add(line);
        }
        return result;
    }

    protected boolean compare(String expected, String actual) {
        if (actual.equals(expected)) {
            return true;
        }
        if (expected.equals("Total time: 1 secs")) {
            return actual.matches("Total time: .+ secs");
        }
        actual = actual.replaceAll("(\\w+(\\.\\w+)*)@\\p{XDigit}+", "$1@12345");
        actual = TextUtil.normaliseFileSeparators((String)actual);
        return actual.equals(expected);
    }
}

