/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer.internal;

import com.google.common.collect.ImmutableSet;
import dev.gradleplugins.test.fixtures.file.TestFile;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleExecuter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.AbstractGradleDistribution;
import dev.gradleplugins.test.fixtures.internal.FilePreconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.util.GradleVersion;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class WrapperGradleDistribution
extends AbstractGradleDistribution {
    private static final Pattern DISTRIBUTION_URL_VERSION_PATTERN = Pattern.compile("(\\d+.\\d+(.\\d+)?(-rc-\\d)?)");
    private final File rootProjectDirectory;

    public WrapperGradleDistribution(File rootProjectDirectory) {
        FilePreconditions.checkIsDirectory(rootProjectDirectory, "Invalid project directory");
        this.assertWrapperInstalled(rootProjectDirectory);
        this.rootProjectDirectory = rootProjectDirectory;
    }

    private void assertWrapperInstalled(File rootProjectDirectory) {
        try {
            ImmutableSet expectedWrapperFiles = ImmutableSet.of((Object)new File(rootProjectDirectory, "gradlew"), (Object)new File(rootProjectDirectory, "gradlew.bat"), (Object)new File(rootProjectDirectory, "gradle/wrapper/gradle-wrapper.properties"), (Object)new File(rootProjectDirectory, "gradle/wrapper/gradle-wrapper.jar"));
            Set actualWrapperFiles = expectedWrapperFiles.stream().filter(File::exists).collect(Collectors.toSet());
            Assert.assertThat(actualWrapperFiles, (Matcher)Matchers.equalTo((Object)expectedWrapperFiles));
        }
        catch (AssertionError ex) {
            throw new IllegalArgumentException(String.format("Invalid wrapper distribution at '%s'.", rootProjectDirectory.getAbsolutePath()), (Throwable)((Object)ex));
        }
    }

    @Override
    public TestFile getGradleHomeDirectory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TestFile getBinaryDirectory() {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public GradleVersion getVersion() {
        File wrapperPropertiesFile = new File(this.rootProjectDirectory, "gradle/wrapper/gradle-wrapper.properties");
        try (FileInputStream inStream = new FileInputStream(wrapperPropertiesFile);){
            Properties wrapperProperties = new Properties();
            wrapperProperties.load(inStream);
            String distributionUrl = Optional.ofNullable(wrapperProperties.getProperty("distributionUrl")).orElseThrow(() -> new IllegalArgumentException(String.format("Unable to retrive 'distributionUrl' property from '%s'.", wrapperPropertiesFile.getAbsolutePath())));
            java.util.regex.Matcher matcher = DISTRIBUTION_URL_VERSION_PATTERN.matcher(distributionUrl);
            if (matcher.find()) {
                GradleVersion gradleVersion = GradleVersion.version((String)matcher.group(1));
                return gradleVersion;
            }
            throw new UnsupportedOperationException(String.format("Unsupported distribution URL format '%s'.", distributionUrl));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(String.format("Unable to locate gradle-wrapper.properties inside project '%s'.", this.rootProjectDirectory.getAbsolutePath()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public GradleExecuter executer(TestFile testDirectoryProvider) {
        return null;
    }
}

