/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.scan;

import dev.gradleplugins.test.fixtures.gradle.executer.GradleExecuter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.util.function.Function;

public class GradleEnterpriseBuildScan
implements Function<GradleExecuter, GradleExecuter> {
    @Override
    public GradleExecuter apply(GradleExecuter executer) {
        return executer.beforeExecute(it -> {
            try (PrintWriter out = new PrintWriter(new FileOutputStream(executer.getTestDirectory().file("build-scan.init.gradle")));){
                out.println("import org.gradle.util.GradleVersion");
                out.println("");
                out.println("def isTopLevelBuild = gradle.getParent() == null");
                out.println("");
                out.println("if (isTopLevelBuild) {");
                out.println("    def gradleVersion = GradleVersion.current().baseVersion");
                out.println("    def atLeastGradle5 = gradleVersion >= GradleVersion.version('5.0')");
                out.println("    def atLeastGradle6 = gradleVersion >= GradleVersion.version('6.0')");
                out.println("");
                out.println("    if (atLeastGradle6) {");
                out.println("        settingsEvaluated {");
                out.println("            if (it.pluginManager.hasPlugin('com.gradle.enterprise')) {");
                out.println("               configureExtension(it.extensions['gradleEnterprise'].buildScan)");
                out.println("            }");
                out.println("        }");
                out.println("    } else if (atLeastGradle5) {");
                out.println("        rootProject {");
                out.println("            if (it.pluginManager.hasPlugin('com.gradle.build-scan')) {");
                out.println("               configureExtension(extensions['buildScan'])");
                out.println("            }");
                out.println("        }");
                out.println("    }");
                out.println("}");
                out.println("");
                out.println("void configureExtension(extension) {");
                out.println("    extension.with {");
                out.println("        termsOfServiceUrl = 'https://gradle.com/terms-of-service'");
                out.println("        termsOfServiceAgree = 'yes'");
                out.println("    }");
                out.println("}");
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException(e);
            }
            return it;
        }).withArgument("--init-script").withArgument(executer.getTestDirectory().file("build-scan.init.gradle").getAbsolutePath()).withArgument("--scan");
    }
}

