/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.plugins;

import dev.gradleplugins.GradlePluginDevelopmentCompatibilityExtension;
import dev.gradleplugins.GradlePluginTestingStrategy;
import dev.gradleplugins.internal.GradlePluginDevelopmentTestSuiteInternal;
import dev.gradleplugins.internal.GradlePluginTestingStrategyInternal;
import dev.gradleplugins.internal.ReleasedVersionDistributions;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.util.GUtil;

public abstract class GradlePluginDevelopmentTestingBasePlugin
implements Plugin<Project> {
    @Inject
    protected abstract TaskContainer getTasks();

    public void apply(Project project) {
        project.getComponents().withType(GradlePluginDevelopmentTestSuiteInternal.class).configureEach(testSuite -> {
            project.afterEvaluate(proj -> {
                testSuite.getTestedSourceSet().disallowChanges();
                if (testSuite.getTestedSourceSet().isPresent()) {
                    SourceSet sourceSet = testSuite.getSourceSet();
                    SourceSet testedSourceSet = (SourceSet)testSuite.getTestedSourceSet().get();
                    sourceSet.setCompileClasspath(sourceSet.getCompileClasspath().plus((FileCollection)testedSourceSet.getOutput()));
                    sourceSet.setRuntimeClasspath(sourceSet.getRuntimeClasspath().plus((FileCollection)sourceSet.getOutput()).plus(sourceSet.getCompileClasspath()));
                }
            });
            project.afterEvaluate(proj -> {
                testSuite.getTestingStrategies().disallowChanges();
                Set strategies = (Set)testSuite.getTestingStrategies().get();
                if (strategies.isEmpty()) {
                    TaskProvider<Test> testTask = this.createTestTask((GradlePluginDevelopmentTestSuiteInternal)testSuite);
                    testTask.configure(this.applyTestActions((GradlePluginDevelopmentTestSuiteInternal)testSuite));
                    this.getTasks().named("check", it -> it.dependsOn(new Object[]{testTask}));
                } else if (strategies.size() == 1) {
                    TaskProvider<Test> testTask = this.createTestTask((GradlePluginDevelopmentTestSuiteInternal)testSuite);
                    testTask.configure(this.applyTestActions((GradlePluginDevelopmentTestSuiteInternal)testSuite));
                    testTask.configure(this.testingStrategy((GradlePluginDevelopmentTestSuiteInternal)testSuite, (GradlePluginTestingStrategyInternal)strategies.iterator().next()));
                    this.getTasks().named("check", it -> it.dependsOn(new Object[]{testTask}));
                } else {
                    for (GradlePluginTestingStrategy strategy : strategies) {
                        TaskProvider<Test> testTask = this.createTestTask((GradlePluginDevelopmentTestSuiteInternal)testSuite, ((GradlePluginTestingStrategyInternal)strategy).getName());
                        testTask.configure(this.applyTestActions((GradlePluginDevelopmentTestSuiteInternal)testSuite));
                        testTask.configure(this.testingStrategy((GradlePluginDevelopmentTestSuiteInternal)testSuite, (GradlePluginTestingStrategyInternal)strategy));
                        this.getTasks().named("check", it -> it.dependsOn(new Object[]{testTask}));
                    }
                }
            });
        });
    }

    private Action<Test> applyTestActions(GradlePluginDevelopmentTestSuiteInternal testSuite) {
        return task -> {
            for (Action<? super Test> action : testSuite.getTestTaskActions()) {
                action.execute(task);
            }
        };
    }

    private Action<Test> testingStrategy(GradlePluginDevelopmentTestSuiteInternal testSuite, GradlePluginTestingStrategyInternal strategy) {
        return task -> {
            String version;
            switch (strategy.getName()) {
                case "minimumGradle": {
                    version = (String)((GradlePluginDevelopmentCompatibilityExtension)testSuite.getTestedGradlePlugin().get()).getMinimumGradleVersion().get();
                    break;
                }
                case "latestNightly": {
                    version = new ReleasedVersionDistributions().getMostRecentSnapshot().getVersion();
                    break;
                }
                case "latestGlobalAvailable": {
                    version = new ReleasedVersionDistributions().getMostRecentRelease().getVersion();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown testing strategy");
                }
            }
            task.systemProperty("dev.gradleplugins.defaultGradleVersion", (Object)version);
        };
    }

    private TaskProvider<Test> createTestTask(GradlePluginDevelopmentTestSuiteInternal testSuite) {
        return this.createTestTask(testSuite, "");
    }

    private TaskProvider<Test> createTestTask(GradlePluginDevelopmentTestSuiteInternal testSuite, String variant) {
        SourceSet sourceSet = testSuite.getSourceSet();
        String taskName = sourceSet.getName() + StringUtils.capitalize((String)variant);
        TaskProvider result = null;
        result = this.getTasks().getNames().contains(taskName) ? this.getTasks().named(taskName, Test.class) : this.getTasks().register(taskName, Test.class);
        result.configure(it -> {
            it.setDescription("Runs the " + GUtil.toWords((CharSequence)sourceSet.getName()) + "s.");
            it.setGroup("verification");
            it.setTestClassesDirs(sourceSet.getOutput().getClassesDirs());
            it.setClasspath(sourceSet.getRuntimeClasspath());
        });
        return result;
    }
}

