/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins;

import dev.gradleplugins.GradlePluginDevelopmentCompatibilityExtension;
import dev.gradleplugins.GradlePluginDevelopmentTestSuite;
import dev.gradleplugins.GradlePluginDevelopmentTestSuiteFactory;
import dev.gradleplugins.internal.ConfigurePluginUnderTestMetadataTask;
import dev.gradleplugins.internal.FinalizableComponent;
import dev.gradleplugins.internal.GradlePluginDevelopmentTestSuiteInternal;
import dev.gradleplugins.internal.ReleasedVersionDistributions;
import dev.gradleplugins.internal.util.GradlePluginDevelopmentUtils;
import java.util.Objects;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.resources.TextResourceFactory;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.tasks.SourceSet;

final class DefaultGradlePluginDevelopmentTestSuiteFactory
implements GradlePluginDevelopmentTestSuiteFactory {
    private final Project project;

    DefaultGradlePluginDevelopmentTestSuiteFactory(Project project) {
        this.project = project;
    }

    @Override
    public GradlePluginDevelopmentTestSuite create(String name) {
        GradlePluginDevelopmentTestSuiteInternal result = (GradlePluginDevelopmentTestSuiteInternal)this.project.getObjects().newInstance(GradlePluginDevelopmentTestSuiteInternal.class, new Object[]{name, this.project, DefaultGradlePluginDevelopmentTestSuiteFactory.minimumGradleVersion(this.project), this.gradleDistributions()});
        result.whenFinalized(new ConfigurePluginUnderTestMetadataTask(this.project));
        result.getSourceSet().convention(this.project.provider(() -> {
            if (this.project.getPluginManager().hasPlugin("java-base")) {
                return (SourceSet)GradlePluginDevelopmentUtils.sourceSets(this.project).maybeCreate(name);
            }
            throw new RuntimeException("Please apply 'java-base' plugin.");
        }));
        result.getTestedSourceSet().convention(this.project.provider(() -> {
            if (this.project.getPluginManager().hasPlugin("java-gradle-plugin")) {
                return GradlePluginDevelopmentUtils.gradlePlugin(this.project).getPluginSourceSet();
            }
            return null;
        }));
        return result;
    }

    private ReleasedVersionDistributions gradleDistributions() {
        if (System.getProperties().containsKey("dev.gradleplugins.internal.use-text-resource")) {
            return new ReleasedVersionDistributions(this.project.getResources().getText());
        }
        if (System.getProperties().containsKey("dev.gradleplugins.internal.use-build-service")) {
            return ((Service)this.project.getGradle().getSharedServices().registerIfAbsent("gradleDistributions", Service.class, it -> {}).get()).initialized(this.project.getResources().getText()).get();
        }
        return ReleasedVersionDistributions.GRADLE_DISTRIBUTIONS;
    }

    private static Provider<String> minimumGradleVersion(Project project) {
        return ((MinimumGradleVersionProvider)project.getObjects().newInstance(MinimumGradleVersionProvider.class, new Object[0])).getMinimumGradleVersion().value(DefaultGradlePluginDevelopmentTestSuiteFactory.ofDevelMinimumGradleVersionIfAvailable(project));
    }

    private static Provider<String> ofDevelMinimumGradleVersionIfAvailable(Project project) {
        return project.provider(() -> {
            if (project.getPluginManager().hasPlugin("java-gradle-plugin") && project.getPluginManager().hasPlugin("dev.gradleplugins.gradle-plugin-base")) {
                ((FinalizableComponent)((Object)GradlePluginDevelopmentCompatibilityExtension.compatibility(GradlePluginDevelopmentUtils.gradlePlugin(project)))).finalizeComponent();
                return GradlePluginDevelopmentCompatibilityExtension.compatibility(GradlePluginDevelopmentUtils.gradlePlugin(project)).getMinimumGradleVersion();
            }
            return Providers.notDefined();
        }).flatMap(DefaultGradlePluginDevelopmentTestSuiteFactory.noOpTransformer());
    }

    private static <T> Transformer<T, T> noOpTransformer() {
        return it -> it;
    }

    protected static interface MinimumGradleVersionProvider {
        public Property<String> getMinimumGradleVersion();
    }

    static abstract class Service
    implements BuildService<BuildServiceParameters.None> {
        private volatile ReleasedVersionDistributions gradleDistributions = null;

        @Inject
        public Service() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Service initialized(TextResourceFactory textResourceFactory) {
            if (this.gradleDistributions == null) {
                Service service = this;
                synchronized (service) {
                    if (this.gradleDistributions == null) {
                        this.gradleDistributions = new ReleasedVersionDistributions(textResourceFactory);
                    }
                }
            }
            return this;
        }

        public ReleasedVersionDistributions get() {
            return Objects.requireNonNull(this.gradleDistributions);
        }
    }
}

