/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal;

import dev.gradleplugins.CompositeGradlePluginTestingStrategy;
import dev.gradleplugins.GradlePluginDevelopmentTestSuite;
import dev.gradleplugins.GradlePluginTestingStrategy;
import dev.gradleplugins.GradleVersionCoverageTestingStrategy;
import dev.gradleplugins.internal.GradlePluginDevelopmentTestSuiteInternal;
import dev.gradleplugins.internal.RegisterTestingStrategyPropertyExtensionRule;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.util.GUtil;

final class CreateTestTasksFromTestingStrategiesRule
implements Action<GradlePluginDevelopmentTestSuite> {
    private final TaskContainer tasks;
    private final ObjectFactory objects;
    private final SetProperty<Test> testElements;

    public CreateTestTasksFromTestingStrategiesRule(TaskContainer tasks, ObjectFactory objects, SetProperty<Test> testElements) {
        this.tasks = tasks;
        this.objects = objects;
        this.testElements = testElements;
    }

    public void execute(GradlePluginDevelopmentTestSuite testSuite) {
        testSuite.getTestingStrategies().disallowChanges();
        Set strategies = (Set)testSuite.getTestingStrategies().get();
        if (strategies.isEmpty()) {
            TaskProvider<Test> testTask = this.createTestTask(testSuite);
            testTask.configure((Action)new RegisterTestingStrategyPropertyExtensionRule(this.objects));
            testTask.configure(this.applyTestActions(testSuite));
        } else if (strategies.size() == 1) {
            TaskProvider<Test> testTask = this.createTestTask(testSuite);
            testTask.configure((Action)new RegisterTestingStrategyPropertyExtensionRule(this.objects));
            testTask.configure(this.configureTestingStrategy(testSuite, (GradlePluginTestingStrategy)strategies.iterator().next()));
            testTask.configure(this.applyTestActions(testSuite));
        } else {
            for (GradlePluginTestingStrategy strategy : strategies) {
                TaskProvider<Test> testTask = this.createTestTask(testSuite, strategy.getName());
                testTask.configure((Action)new RegisterTestingStrategyPropertyExtensionRule(this.objects));
                testTask.configure(this.configureTestingStrategy(testSuite, strategy));
                testTask.configure(this.applyTestActions(testSuite));
            }
        }
    }

    private Action<Test> applyTestActions(GradlePluginDevelopmentTestSuite testSuite) {
        return task -> {
            for (Action<? super Test> action : ((GradlePluginDevelopmentTestSuiteInternal)testSuite).getTestTaskActions()) {
                action.execute(task);
            }
        };
    }

    private Action<Test> configureTestingStrategy(GradlePluginDevelopmentTestSuite testSuite, GradlePluginTestingStrategy strategy) {
        return task -> {
            Stream.of(strategy).flatMap(this::unpackCompositeTestingStrategy).flatMap(this::onlyCoverageTestingStrategy).map(GradleVersionCoverageTestingStrategy::getVersion).findFirst().ifPresent(CreateTestTasksFromTestingStrategiesRule.setDefaultGradleVersionSystemProperty(task));
            RegisterTestingStrategyPropertyExtensionRule.testingStrategyProperty(task).set((Object)strategy);
        };
    }

    private static Consumer<String> setDefaultGradleVersionSystemProperty(Test task) {
        return version -> task.systemProperty("dev.gradleplugins.defaultGradleVersion", version);
    }

    private Stream<GradleVersionCoverageTestingStrategy> onlyCoverageTestingStrategy(GradlePluginTestingStrategy strategy) {
        if (strategy instanceof GradleVersionCoverageTestingStrategy) {
            return Stream.of((GradleVersionCoverageTestingStrategy)strategy);
        }
        return Stream.empty();
    }

    private Stream<GradlePluginTestingStrategy> unpackCompositeTestingStrategy(GradlePluginTestingStrategy strategy) {
        if (strategy instanceof CompositeGradlePluginTestingStrategy) {
            return StreamSupport.stream(((CompositeGradlePluginTestingStrategy)strategy).spliterator(), false);
        }
        return Stream.of(strategy);
    }

    private TaskProvider<Test> createTestTask(GradlePluginDevelopmentTestSuite testSuite) {
        return this.createTestTask(testSuite, "");
    }

    private TaskProvider<Test> createTestTask(GradlePluginDevelopmentTestSuite testSuite, String variant) {
        String taskName = testSuite.getName() + StringUtils.capitalize((String)variant);
        TaskProvider result = null;
        result = this.tasks.getNames().contains(taskName) ? this.tasks.named(taskName, Test.class) : this.tasks.register(taskName, Test.class);
        result.configure(it -> {
            it.setDescription("Runs the " + GUtil.toWords((CharSequence)testSuite.getName()) + "s.");
            it.setGroup("verification");
            it.setTestClassesDirs((FileCollection)this.objects.fileCollection().from(new Object[]{testSuite.getSourceSet().map(t -> t.getOutput().getClassesDirs()).orElse(Collections.emptyList())}));
            it.setClasspath((FileCollection)this.objects.fileCollection().from(new Object[]{testSuite.getSourceSet().map(t -> t.getRuntimeClasspath()).orElse(Collections.emptyList())}));
        });
        this.testElements.add((Provider)result);
        return result;
    }
}

