/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import dev.gradleplugins.internal.GradleVersionsService;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import org.gradle.api.resources.TextResourceFactory;

public class ReleasedVersionDistributions {
    public static final ReleasedVersionDistributions GRADLE_DISTRIBUTIONS = new ReleasedVersionDistributions();
    private GradleRelease mostRecentSnapshot;
    private GradleRelease mostRecentRelease;
    private List<GradleRelease> allVersions;
    private final GradleVersionsService versions;

    public ReleasedVersionDistributions() {
        this(new HostedGradleVersionsService());
    }

    public ReleasedVersionDistributions(TextResourceFactory textResourceFactory) {
        this(new TextResourceHostedGradleVersionsService(textResourceFactory));
    }

    public ReleasedVersionDistributions(GradleVersionsService versions) {
        this.versions = versions;
    }

    public GradleRelease getMostRecentSnapshot() {
        if (this.mostRecentSnapshot == null) {
            try (Reader reader = this.versions.nightly();){
                this.mostRecentSnapshot = (GradleRelease)new Gson().fromJson(reader, GradleRelease.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to get the last snapshot version", e);
            }
        }
        return this.mostRecentSnapshot;
    }

    public GradleRelease getMostRecentRelease() {
        if (this.mostRecentRelease == null) {
            try (Reader reader = this.versions.current();){
                this.mostRecentRelease = (GradleRelease)new Gson().fromJson(reader, GradleRelease.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to get the last version", e);
            }
        }
        return this.mostRecentRelease;
    }

    public List<GradleRelease> getAllVersions() {
        if (this.allVersions == null) {
            try (Reader reader = this.versions.all();){
                this.allVersions = (List)new Gson().fromJson(reader, new TypeToken<List<GradleRelease>>(){}.getType());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to get the last version", e);
            }
        }
        return this.allVersions;
    }

    private static final class TextResourceHostedGradleVersionsService
    implements GradleVersionsService {
        private final TextResourceFactory textResourceFactory;

        public TextResourceHostedGradleVersionsService(TextResourceFactory textResourceFactory) {
            this.textResourceFactory = textResourceFactory;
        }

        @Override
        public Reader nightly() throws IOException {
            return this.textResourceFactory.fromUri((Object)"https://services.gradle.org/versions/nightly").asReader();
        }

        @Override
        public Reader current() throws IOException {
            return this.textResourceFactory.fromUri((Object)"https://services.gradle.org/versions/current").asReader();
        }

        @Override
        public Reader all() throws IOException {
            return this.textResourceFactory.fromUri((Object)"https://services.gradle.org/versions/all").asReader();
        }
    }

    private static final class HostedGradleVersionsService
    implements GradleVersionsService {
        private HostedGradleVersionsService() {
        }

        @Override
        public Reader nightly() throws IOException {
            return new InputStreamReader(new URL("https://services.gradle.org/versions/nightly").openConnection().getInputStream());
        }

        @Override
        public Reader current() throws IOException {
            return new InputStreamReader(new URL("https://services.gradle.org/versions/current").openConnection().getInputStream());
        }

        @Override
        public Reader all() throws IOException {
            return new InputStreamReader(new URL("https://services.gradle.org/versions/all").openConnection().getInputStream());
        }
    }

    public static final class GradleRelease {
        private final String version;
        private final boolean snapshot;
        private final boolean current;
        private final String rcFor;

        public GradleRelease(String version, boolean snapshot, boolean current, String rcFor) {
            this.version = version;
            this.snapshot = snapshot;
            this.current = current;
            this.rcFor = rcFor;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean isSnapshot() {
            return this.snapshot;
        }

        public boolean isCurrent() {
            return this.current;
        }

        public String getRcFor() {
            return this.rcFor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradleRelease)) {
                return false;
            }
            GradleRelease other = (GradleRelease)o;
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            if (this.isSnapshot() != other.isSnapshot()) {
                return false;
            }
            if (this.isCurrent() != other.isCurrent()) {
                return false;
            }
            String this$rcFor = this.getRcFor();
            String other$rcFor = other.getRcFor();
            return !(this$rcFor == null ? other$rcFor != null : !this$rcFor.equals(other$rcFor));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            result = result * 59 + (this.isSnapshot() ? 79 : 97);
            result = result * 59 + (this.isCurrent() ? 79 : 97);
            String $rcFor = this.getRcFor();
            result = result * 59 + ($rcFor == null ? 43 : $rcFor.hashCode());
            return result;
        }

        public String toString() {
            return "ReleasedVersionDistributions.GradleRelease(version=" + this.getVersion() + ", snapshot=" + this.isSnapshot() + ", current=" + this.isCurrent() + ", rcFor=" + this.getRcFor() + ")";
        }
    }
}

